/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.BooleanResult;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.ProcessorState;
import org.w3c.dom.Node;

public class AndExpr
implements Expr {
    private static String AND = " and ";
    private static String NULL = "null";
    private Expr leftExpr = null;
    private Expr rightExpr = null;

    public AndExpr(Expr expr, Expr expr2) {
        this.leftExpr = expr;
        this.rightExpr = expr2;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        if (this.leftExpr == null || this.rightExpr == null) {
            return BooleanResult.FALSE_RESULT;
        }
        if (!this.leftExpr.evaluate(node, processorState).booleanValue()) {
            return BooleanResult.FALSE_RESULT;
        }
        return new BooleanResult(this.rightExpr.evaluate(node, processorState));
    }

    public short getExprType() {
        return 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.leftExpr != null) {
            stringBuffer.append(this.leftExpr.toString());
        } else {
            stringBuffer.append(NULL);
        }
        stringBuffer.append(AND);
        if (this.rightExpr != null) {
            stringBuffer.append(this.rightExpr.toString());
        } else {
            stringBuffer.append(NULL);
        }
        return stringBuffer.toString();
    }
}

