/**
 * The contents of this file are subject to the OpenXML Public
 * License Version 1.0; you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.openxml.org/license/
 *
 * THIS SOFTWARE AND DOCUMENTATION IS PROVIDED ON AN "AS IS" BASIS
 * WITHOUT WARRANTY OF ANY KIND EITHER EXPRESSED OR IMPLIED,
 * INCLUDING AND WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE
 * AND DOCUMENTATION IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGING. SEE THE LICENSE FOR THE
 * SPECIFIC LANGUAGE GOVERNING RIGHTS AND LIMITATIONS UNDER THE
 * LICENSE.
 *
 * The Initial Developer of this code under the License is
 * OpenXML.org. Portions created by OpenXML.org and/or Assaf Arkin
 * are Copyright (C) 1998, 1999 OpenXML.org. All Rights Reserved.
 */


package examples;


import java.io.*;
import java.util.*;
import org.w3c.dom.*;
import org.openxml.*;
import org.openxml.io.*;
import org.openxml.x3p.*;
import org.openxml.util.*;


/**
 * @version $Revision: 1.1 $ $Date: 1999/04/12 06:07:35 $
 * @author <a href="mailto:arkin@trendline.co.il">Assaf Arkin</a>
 */
public class Ex2
{


    public static void main( String args[] )
    {
        try
        {
            Parser          parser;
            InputStream     is;
            Document        doc;
            NodeList        nl;
            NamedNodeMap    nm;
            int             i, l;
            String          name;

            is = new FileInputStream( "examples/ex2.xml" );
            parser = DOMFactory.createParser( is, null, null );
            doc = parser.parseDocument();

            nl = doc.getElementsByTagName( "title" );
            l = nl.getLength();
            System.out.println( "Listing contents of all title elements in document:" );
            for ( i = 0 ; i < l ; ++i )
                System.out.println( i + ": " + nl.item( i ).getFirstChild().getNodeValue() );
            
            nl = doc.getElementsByTagName( "page" );
            nl = nl.item( 0 ).getChildNodes();
            l = nl.getLength();
            System.out.println( "\nListing all child nodes of page element:" );
            for ( i = 0 ; i < l ; ++i )
                System.out.println( i + ": " + nl.item( i ).getNodeName() );
            
            nl = doc.getElementsByTagName( "page" );
            nm = nl.item( 0 ).getAttributes();
            l = nm.getLength();
            System.out.println( "\nListing all attributes of page element:" );
            for ( i = 0 ; i < l ; ++i )
            {
                name = nm.item( i ).getNodeName();
                System.out.println( i + ": " + name + "=" + nm.getNamedItem( name ).getNodeValue() );
            }
        }
        catch ( Exception except )
        {
            System.out.println( except );
            except.printStackTrace( System.err );
        }
    }


    static void list( Node node )
    {
        while ( node != null )
        {
            System.out.println( "Node name [" + node.getNodeName() + "] value [" + node.getNodeValue() + "]" );
            if ( node.hasChildNodes() )
                list( node.getFirstChild() );
            node = node.getNextSibling();
        }
    }


}

