package com.jtauber.fop.layout;

import com.jtauber.fop.render.Renderer;

public class ImageArea extends Area {

    protected int[] pixels;
    protected int pheight;
    protected int pwidth;

    public ImageArea(FontState fontState, int width, int height,
		     int pheight, int pwidth, int[] pixels) {
	super(fontState, width, height);
	this.currentHeight = height;
	this.contentRectangleWidth = width;
	this.pheight = pheight;
	this.pwidth = pwidth;
	this.pixels = pixels;
    }

    public void render(Renderer renderer) {
	renderer.renderImageArea(this);
    }

    public int getPHeight() {
	return this.pheight;
    }

    public int getPWidth() {
	return this.pwidth;
    }

    public int[] getPixels() {
	return this.pixels;
    }
}
