package com.jtauber.fop.apps;

// FOP
import com.jtauber.fop.render.xml.XMLRenderer;

// SAX
import org.xml.sax.Parser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

// Java
import java.io.FileReader;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.net.URL;

/**
 * mainline class that uses XMLRenderer.
 *
 * Gets input and output filenames from the command line.
 * Creates a SAX Parser (defaulting to XP).
 * 
 */
public class CommandLineXML extends CommandLine {

    /**
     * mainline method
     *
     * first command line argument is input file
     * second command line argument is output file
     *
     * @param args command line arguments
     */
    public static void main(String[] args) {
	String version = com.jtauber.fop.Version.getVersion();

	System.err.println(version);
		
	if (args.length != 2) {
	    System.err.println("usage: java "
			       + "com.jtauber.fop.apps.CommandLine "
			       + "formatting-object-file pdf-file");
	    System.exit(1);
	}
	
	Parser parser = createParser();
	
	if (parser == null) {
	    System.err.println("ERROR: Unable to create SAX parser");
	    System.exit(1);
	}
	
	try {
	    PrintWriter writer =
		new PrintWriter(new FileWriter(args[1]));
	    SAXProcessor fop =
		new SAXProcessor(parser, fileInputSource(args[0]),
				 new XMLRenderer(version)); 
	    
	    fop.format(writer);
	} catch (FOPException e) {
	    System.err.println("FATAL ERROR: "+ e.getMessage());
	    System.exit(1);
	} catch (FileNotFoundException e) {
	    System.err.println("FATAL ERROR: File not found: "+args[0]);
	    System.exit(1);
	} catch (IOException e) {
	    System.err.println("FATAL ERROR: I/O problem with "+args[1]);
	    System.exit(1);
	}
    }
}
