/*
 * Decompiled with CFR 0.152.
 */
package com.jtauber.fop.fo.flow;

import com.jtauber.fop.apps.FOPException;
import com.jtauber.fop.fo.FONode;
import com.jtauber.fop.fo.FObj;
import com.jtauber.fop.fo.FObjMixed;
import com.jtauber.fop.fo.PropertyList;
import com.jtauber.fop.layout.Area;
import com.jtauber.fop.layout.BlockArea;
import com.jtauber.fop.layout.FontState;

public class Block
extends FObjMixed {
    FontState fs;
    int align;
    int alignLast;
    int breakBefore;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    int textIndent;
    BlockArea blockArea;
    boolean anythingLaidOut = false;

    public Block(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:block";
    }

    public int getAreaHeight() {
        return this.blockArea.getHeight();
    }

    public int layout(Area area) throws FOPException {
        int n;
        Object object;
        if (this.marker == -1001) {
            return 1;
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            object = this.properties.get("font-weight").getString();
            n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, (String)object, n);
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.textIndent = this.properties.get("text-indent").getLength().mvalue();
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.isInLabel) {
                this.startIndent += this.bodyIndent;
                this.endIndent += area.getAllocationWidth() - this.distanceBetweenStarts - this.startIndent + this.labelSeparation;
            }
            if (this.isInListBody) {
                this.startIndent += this.bodyIndent + this.distanceBetweenStarts;
            }
            this.marker = 0;
            if (this.breakBefore == 3) {
                return 4;
            }
            if (this.breakBefore == 5) {
                return 6;
            }
            if (this.breakBefore == 4) {
                return 5;
            }
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.anythingLaidOut) {
            this.textIndent = 0;
        }
        this.blockArea = new BlockArea(this.fs, area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, this.textIndent, this.align, this.alignLast, this.lineHeight);
        this.blockArea.setPage(area.getPage());
        this.blockArea.start();
        int n2 = this.children.size();
        int n3 = this.marker;
        while (n3 < n2) {
            object = (FONode)this.children.elementAt(n3);
            if (this.isInListBody) {
                ((FONode)object).setIsInListBody();
                ((FONode)object).setDistanceBetweenStarts(this.distanceBetweenStarts);
                ((FONode)object).setBodyIndent(this.bodyIndent);
            }
            if ((n = ((FONode)object).layout(this.blockArea)) != 1) {
                this.marker = n3;
                if (n3 != 0 && n == 2) {
                    n = 3;
                }
                area.addChild(this.blockArea);
                area.increaseHeight(this.blockArea.getHeight());
                this.anythingLaidOut = true;
                return n;
            }
            this.anythingLaidOut = true;
            ++n3;
        }
        this.blockArea.end();
        area.addChild(this.blockArea);
        area.increaseHeight(this.blockArea.getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        if (this.breakAfter == 3) {
            this.marker = -1001;
            return 4;
        }
        if (this.breakAfter == 5) {
            this.marker = -1001;
            return 6;
        }
        if (this.breakAfter == 4) {
            this.marker = -1001;
            return 5;
        }
        return 1;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Block(fObj, propertyList);
        }
    }
}

