/*
** RCS_ID = $Id: defs.h,v 1.15 1996/09/22 13:07:11 stefan Exp $
**
** Common definitions for http-analyze
**
** $Log: defs.h,v $
** Revision 1.15  1996/09/22  13:07:11  stefan
** Introduced macros for the request method.
**
** Revision 1.14  1996/07/03  16:32:29  stefan
** Fixed a bug with a wrong prototype which caused gcc to complain.
**
** Revision 1.13  1996/06/25  12:49:11  stefan
** Fixed bug with wrong definition of MKUPPER/MKLOWER.
**
** Revision 1.12  1996/06/18  16:18:01  stefan
** List of sites now used in cntrycode.c also.
**
** Revision 1.11  1996/06/18  13:32:00  stefan
** Added definition for FILENAME_MAX if not defined in the
** standard headers to simplify porting to non-ANSI environments.
**
** Revision 1.10  1996/06/17  19:43:19  stefan
** Changed `lastday' into `ishidden' in the NLIST structure
** to reflect new usage: in the global site list, this flag
** is used to save the last day the site has visited the
** server, while in the global URL list it contains the
** index into the list of hidden items if applicable.
** This allows to create a list of all URLs per hidden item.
**
** Revision 1.9  1996/06/15  10:56:11  stefan
** Added a counter for the total size of all responses other
** than Code 200 (OK) and Code 304 (Not Modified) responses.
**
** Revision 1.8  1996/06/13  18:32:05  stefan
** Increased value for the line buffer of the parser
** (parameter BIGSIZE) to 10KB (again).
**
** Revision 1.7  1996/05/29  05:57:04  stefan
** Added some new declarations.
**
** Revision 1.6  1996/05/25  16:29:14  stefan
** Added element lastday to the NLIST structure.
**
** Revision 1.5  1996/05/25  01:52:56  stefan
** Modified according to the changes in version 1.9.
**
** Revision 1.4  1996/05/09  09:11:14  stefan
** Added new declarations.
**
** Revision 1.3  1996/05/08  15:42:16  stefan
** Cosmetic changes only.
**
** Revision 1.2  1996/01/21  16:38:48  stefan
** Removed unused doc_root variable, added TOP_COUNTER definition.
**
** Revision 1.1  1996/01/17  00:00:00  stefan
** Initial revision
**
**
*/

/******************************************************************/
/* End of user configuration section. There should be no need to **/
/* modify any of the definitions below.                          **/
/******************************************************************/

/*
** The following macros are used to replace calls to islower() and
** friends for the sake of speed. Because this works only in ASCII
** environments, the program isn't strictly ANSI-conforming anymore.
*/
#if !defined(STRICT_ANSI)
# define MKUPPER(pt)	if (*pt >= 'a' && *pt <= 'z') *pt -= 'a'-'A'
# define MKLOWER(pt)	if (*pt >= 'A' && *pt <= 'Z') *pt += 'a'-'A'
#else
# define MKUPPER(pt)	if (islower(*pt)) *pt = toupper(*pt)
# define MKLOWER(pt)	if (isupper(*pt)) *pt = tolower(*pt)
#endif

/* To simplify porting to non-ANSI environments */
#if !defined(FILENAME_MAX)
# define FILENAME_MAX	1024
#endif

#define streq(s1,s2)	(!strcasecmp((s1), (s2)))
#define strneq(s1,s2,n)	(!strncasecmp((s1), (s2), (n)))

#define SMALLSIZE	100
#define BIGSIZE		10240	/* set to 10K again for huge logfile entries */
#define LBUFSIZE	4096	/* use smaller size for other line buffers */

#define TIME_FMT	"%02d/%3.3s/%d"
#define EPOCH(yr)	((yr) >= 2000 ? (yr)-2000 : (yr)-1900)
#define TABSIZE(arr)	(sizeof(arr)/sizeof(arr[0]))
#define MAX_HPNAMES	5

#define HTML_HEADPFX	0
#define HTML_HEADSFX	1
#define HTML_TRAILER	2

/* codes for the request method */
#define METHOD_UNKNOWN	0
#define METHOD_GET	1
#define METHOD_HEAD	2
#define METHOD_POST	3

/* codes for isHiddenItem() in utils.c */
#define MAX_HIDDEN_SITES        100
#define MAX_HIDDEN_ITEMS        200
#define HIDDEN_SITES	0
#define HIDDEN_ITEMS	1

/* time format */
typedef struct {
	u_short mday;	/* day of month [1..31] */
	u_short mon;	/* month of year [0..11] */
	u_short year;	/* year [1900..2048] */
	u_short hour;	/* hour [0..23] */
	u_short min;	/* min [0..59] */
	u_short sec;	/* sec [0..61] */
} LOGTIME;

/* logfile entry */
typedef struct {
	char *sitename;	/* hostname or IP address */
	char *request;	/* URL of request */
#if defined(USER_AGENT)
	char *uagent;	/* user agent */
#endif
	size_t sitelen;	/* length of sitename */
	size_t reqlen;	/* length of request */
	u_int respidx;	/* server response index */
	u_long reqsize;	/* size of request */
	LOGTIME tm;	/* timestamp */
} LOGENT;

/* hash list element */
typedef struct NLIST {
	char *str;	/* URL of request or sitename */
	size_t len;	/* length of string */
	short ishidden;	/* set if hidden */
	u_long count;	/* access counter */
	u_long nomod;	/* No Modification counter (304) */
	u_long size;	/* size of document if known */
	double bytes;	/* total transfer count */
	struct NLIST *next;
} NLIST;

/* HTTP response codes */
typedef struct {
	int code;	/* message code */
	int size;	/* additional overhead of response */
	u_long count;	/* total count */
	double bytes;	/* total transfer count */
	char *msg;	/* message if any */
} RESPONSE;

/* country code table */
typedef struct {
	u_short code;	/* list of two-letter country codes */
	char *name;
	u_long count;
	u_long nomod;
	double bytes;
} COUNTRY;

/* ignored items */
typedef struct {
	size_t len;	/* string length of pfx (will be initialized) */
	char *pfx;	/* prefix to compare (description now is in col.str) */
	NLIST *col;	/* collector for data */
} ITEM_LIST;

#if defined(USER_AGENT)
typedef struct {
	u_long count;	/* number of hits per user agent */
	size_t len;	/* string length */
	u_int sum;	/* string sum */
	char *name;	/* name of user agent */
} UAGENT;
#endif

/* top hits counters */
typedef struct {
	u_long count;		/* hits */
	u_long nomod;		/* 304 requests */
	double bytes;		/* bytes sent */
	LOGTIME tm;		/* timestamp */
} TOP_COUNTER;

/* definitions for small icons */
#define SQICON_GREEN	icon_tab[0].name
#define SQICON_BLUE	icon_tab[1].name
#define SQICON_RED	icon_tab[2].name
#define SQICON_ORANGE	icon_tab[3].name
#define SQICON_YELLOW	icon_tab[4].name

typedef struct {
	char *name;
	int color[3];
} ICON_TAB;

/* global variables in http-analyze.c */
extern char *srv_name;		/* name of this server */
extern char *log_file;		/* name of the logfile */
extern char *priv_dir;		/* private directory for site/URL lists */
extern char *out_dir;		/* directory for HTML output files */
extern char *doc_title;		/* document title */
extern char *monnam[];		/* list of month names */
extern char *html_str[];	/* HTML strings */
extern char *home_page[];	/* alternate homepage names */
extern int monthly;		/* if set create monthly summary */
extern int hpnum;		/* number of homepage names */

extern LOGTIME tstart, tend;	/* start and end time */
extern ICON_TAB icon_tab[];	/* names for small icons in images.c */

/* counters in http-analyze.c */
extern u_long total_hits, mn_hits[], mn_files[], /*mn_nomod[],*/ mn_sites[], mn_kbytes[];
extern u_long daily_hits[], daily_files[], /*daily_nomod[],*/ daily_sites[], daily_kbytes[];
extern u_long hr_hits[], whr_hits[7][24];
extern int topn_sites, topn_urls, lastn_urls;
extern char *mn_str[];

/* lists in util.c */
extern ITEM_LIST hidden_sites[]; /* list of hidden sites */
extern ITEM_LIST hidden_items[]; /* list of hidden items */
extern NLIST *hstab[101];	/* collector for hidden sites */
extern NLIST *hitab[101];	/* ... and hidden items */

/* function prototypes for http-analyze.c */
NLIST *lookupItem(NLIST ** const htab, size_t const hsize, char * const str);
void prmsg(int const, char * const, ...);

/* function prototypes for utils.c */
int readcfg(char * const);
int setDate(LOGTIME * const, char const *);
void defHiddenItem(void);
int isHiddenItem(int const, NLIST * const);
void initHiddenItems(void);
char *strsave(char *);

/* function prototypes for images.c */
int mn_bars(int, int, int, char *);
int hr_bars(int, int, int, char *);
int c_chart(int, int, int, char *, COUNTRY **, size_t);
int graph(int, int, int, char *);
void checkForIcons(void);
