#if !defined(lint)
static char rcs_id[] = "$Id: cntrycode.c,v 1.5 1996/06/25 13:06:33 stefan Exp $";
#endif

/*
** country codes for http-analyze
**
** Copyright 1996 by Stefan Stapelberg, <stefan@rent-a-guru.de>
**
** $Log: cntrycode.c,v $
** Revision 1.5  1996/06/25  13:06:33  stefan
** Modified algorithm for determining the country.
** Fixed some bugs. Now prints a warning for unknown
** top-level-domains just in case ...
**
** Revision 1.4  1996/06/18  16:16:55  stefan
** Retrieves two-letter country code from original string
** if a site is hidden under some item.
**
** Revision 1.3  1996/05/25  01:51:44  stefan
** Made domain names case-insensitive by converting all sitenames
** to lower case before doing comparisons, so we can use strcmp(3)
** instead of strcasecmp(3), thus increasing portability and speed.
** Fixed bug where list of countries was lost when analyzing logs
** for more than one month in the same run.
**
** Revision 1.2  1996/05/08  14:37:27  stefan
** Fixed bug where country list get lost when analyzing
** two or more month at once.
**
** Revision 1.1  1996/01/17  00:00:00  stefan
** Initial revision
**
**
*/

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>		/* for def.h */

#include "defs.h"
#include "cntrycode.h"

/*
 * ISO two letter country codes.
 * Note: the first 10 elements are reserved for non-country domains.
 * See also the file cntrycode.h
 */

static COUNTRY country[] = {
	{ 0,			"Unknown",	0L, 0L, 0.0 },
	{ 0,			"Unresolved",	0L, 0L, 0.0 },
	{ 0,			"Network",	0L, 0L, 0.0 },		/* NET */
	{ 0,			"US Commercial", 0L, 0L, 0.0 },		/* COM */
	{ 0,			"US Educational", 0L, 0L, 0.0 },	/* EDU */
	{ 0,			"US Government", 0L, 0L, 0.0 },		/* GOV */
	{ 0,			"International", 0L, 0L, 0.0 },		/* INT */
	{ 0,			"US Military", 0L, 0L, 0.0 },		/* MIL */
	{ 0,			"Non-Profit Organization", 0L, 0L, 0.0 }, /* ORG */
	{ 0,			"Old style Arpanet", 0L, 0L, 0.0 },	/* ARPA */
	{ 0,			"Nato field", 0L, 0L, 0.0 },		/* NATO */
	{ CC_PAIR('a', 'd'),	"Andorra",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'e'),	"United Arab Emirates",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'f'),	"Afghanistan",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'g'),	"Antigua and Barbuda",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'i'),	"Anguilla",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'l'),	"Albania",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'm'),	"Armenia",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'n'),	"Netherlands Antilles",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'o'),	"Angola",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'q'),	"Antarctica",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'r'),	"Argentina",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 's'),	"American Samoa",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 't'),	"Austria",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'u'),	"Australia",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'w'),	"Aruba",	0L, 0L, 0.0 },
	{ CC_PAIR('a', 'z'),	"Azerbaijan",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'a'),	"Bosnia and Herzegovina",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'b'),	"Barbados",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'd'),	"Bangladesh",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'e'),	"Belgium",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'f'),	"Burkina Faso",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'g'),	"Bulgaria",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'h'),	"Bahrain",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'i'),	"Burundi",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'j'),	"Benin",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'm'),	"Bermuda",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'n'),	"Brunei Darussalam",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'o'),	"Bolivia",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'r'),	"Brazil",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 's'),	"Bahamas",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 't'),	"Bhutan",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'v'),	"Bouvet Island",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'w'),	"Botswana",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'y'),	"Belarus",	0L, 0L, 0.0 },
	{ CC_PAIR('b', 'z'),	"Belize",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'a'),	"Canada",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'c'),	"Cocos (Keeling) Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'f'),	"Central African Republic",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'g'),	"Congo",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'h'),	"Switzerland",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'i'),	"Cote D'Ivoire (Ivory Coast)",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'k'),	"Cook Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'l'),	"Chile",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'm'),	"Cameroon",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'n'),	"China",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'o'),	"Colombia",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'r'),	"Costa Rica",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 's'),	"Czechoslovakia (former)",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'u'),	"Cuba",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'v'),	"Cape Verde",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'x'),	"Christmas Island",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'y'),	"Cyprus",	0L, 0L, 0.0 },
	{ CC_PAIR('c', 'z'),	"Czech Republic",	0L, 0L, 0.0 },
	{ CC_PAIR('d', 'e'),	"Germany",	0L, 0L, 0.0 },
	{ CC_PAIR('d', 'j'),	"Djibouti",	0L, 0L, 0.0 },
	{ CC_PAIR('d', 'k'),	"Denmark",	0L, 0L, 0.0 },
	{ CC_PAIR('d', 'm'),	"Dominica",	0L, 0L, 0.0 },
	{ CC_PAIR('d', 'o'),	"Dominican Republic",	0L, 0L, 0.0 },
	{ CC_PAIR('d', 'z'),	"Algeria",	0L, 0L, 0.0 },
	{ CC_PAIR('e', 'c'),	"Ecuador",	0L, 0L, 0.0 },
	{ CC_PAIR('e', 'e'),	"Estonia",	0L, 0L, 0.0 },
	{ CC_PAIR('e', 'g'),	"Egypt",	0L, 0L, 0.0 },
	{ CC_PAIR('e', 'h'),	"Western Sahara",	0L, 0L, 0.0 },
	{ CC_PAIR('e', 'r'),	"Eritrea",	0L, 0L, 0.0 },
	{ CC_PAIR('e', 's'),	"Spain",	0L, 0L, 0.0 },
	{ CC_PAIR('e', 't'),	"Ethiopia",	0L, 0L, 0.0 },
	{ CC_PAIR('f', 'i'),	"Finland",	0L, 0L, 0.0 },
	{ CC_PAIR('f', 'j'),	"Fiji",	0L, 0L, 0.0 },
	{ CC_PAIR('f', 'k'),	"Falkland Islands (Malvinas)",	0L, 0L, 0.0 },
	{ CC_PAIR('f', 'm'),	"Micronesia",	0L, 0L, 0.0 },
	{ CC_PAIR('f', 'o'),	"Faroe Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('f', 'r'),	"France",	0L, 0L, 0.0 },
	{ CC_PAIR('f', 'x'),	"France, Metropolitan",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'a'),	"Gabon",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'b'),	"Great Britain (UK)",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'd'),	"Grenada",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'e'),	"Georgia",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'f'),	"French Guiana",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'h'),	"Ghana",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'i'),	"Gibraltar",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'l'),	"Greenland",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'm'),	"Gambia",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'n'),	"Guinea",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'p'),	"Guadeloupe",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'q'),	"Equatorial Guinea",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'r'),	"Greece",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 's'),	"S. Georgia and S. Sandwich Isls.",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 't'),	"Guatemala",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'u'),	"Guam",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'w'),	"Guinea-Bissau",	0L, 0L, 0.0 },
	{ CC_PAIR('g', 'y'),	"Guyana",	0L, 0L, 0.0 },
	{ CC_PAIR('h', 'k'),	"Hong Kong",	0L, 0L, 0.0 },
	{ CC_PAIR('h', 'm'),	"Heard and McDonald Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('h', 'n'),	"Honduras",	0L, 0L, 0.0 },
	{ CC_PAIR('h', 'r'),	"Croatia (Hrvatska)",	0L, 0L, 0.0 },
	{ CC_PAIR('h', 't'),	"Haiti",	0L, 0L, 0.0 },
	{ CC_PAIR('h', 'u'),	"Hungary",	0L, 0L, 0.0 },
	{ CC_PAIR('i', 'd'),	"Indonesia",	0L, 0L, 0.0 },
	{ CC_PAIR('i', 'e'),	"Ireland",	0L, 0L, 0.0 },
	{ CC_PAIR('i', 'l'),	"Israel",	0L, 0L, 0.0 },
	{ CC_PAIR('i', 'n'),	"India",	0L, 0L, 0.0 },
	{ CC_PAIR('i', 'o'),	"British Indian Ocean Territory",	0L, 0L, 0.0 },
	{ CC_PAIR('i', 'q'),	"Iraq",	0L, 0L, 0.0 },
	{ CC_PAIR('i', 'r'),	"Iran",	0L, 0L, 0.0 },
	{ CC_PAIR('i', 's'),	"Iceland",	0L, 0L, 0.0 },
	{ CC_PAIR('i', 't'),	"Italy",	0L, 0L, 0.0 },
	{ CC_PAIR('j', 'm'),	"Jamaica",	0L, 0L, 0.0 },
	{ CC_PAIR('j', 'o'),	"Jordan",	0L, 0L, 0.0 },
	{ CC_PAIR('j', 'p'),	"Japan",	0L, 0L, 0.0 },
	{ CC_PAIR('k', 'e'),	"Kenya",	0L, 0L, 0.0 },
	{ CC_PAIR('k', 'g'),	"Kyrgyzstan",	0L, 0L, 0.0 },
	{ CC_PAIR('k', 'h'),	"Cambodia",	0L, 0L, 0.0 },
	{ CC_PAIR('k', 'i'),	"Kiribati",	0L, 0L, 0.0 },
	{ CC_PAIR('k', 'm'),	"Comoros",	0L, 0L, 0.0 },
	{ CC_PAIR('k', 'n'),	"Saint Kitts and Nevis",	0L, 0L, 0.0 },
	{ CC_PAIR('k', 'p'),	"Korea (North)",	0L, 0L, 0.0 },
	{ CC_PAIR('k', 'r'),	"Korea (South)",	0L, 0L, 0.0 },
	{ CC_PAIR('k', 'w'),	"Kuwait",	0L, 0L, 0.0 },
	{ CC_PAIR('k', 'y'),	"Cayman Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('k', 'z'),	"Kazakhstan",	0L, 0L, 0.0 },
	{ CC_PAIR('l', 'a'),	"Laos",	0L, 0L, 0.0 },
	{ CC_PAIR('l', 'b'),	"Lebanon",	0L, 0L, 0.0 },
	{ CC_PAIR('l', 'c'),	"Saint Lucia",	0L, 0L, 0.0 },
	{ CC_PAIR('l', 'i'),	"Liechtenstein",	0L, 0L, 0.0 },
	{ CC_PAIR('l', 'k'),	"Sri Lanka",	0L, 0L, 0.0 },
	{ CC_PAIR('l', 'r'),	"Liberia",	0L, 0L, 0.0 },
	{ CC_PAIR('l', 's'),	"Lesotho",	0L, 0L, 0.0 },
	{ CC_PAIR('l', 't'),	"Lithuania",	0L, 0L, 0.0 },
	{ CC_PAIR('l', 'u'),	"Luxembourg",	0L, 0L, 0.0 },
	{ CC_PAIR('l', 'v'),	"Latvia",	0L, 0L, 0.0 },
	{ CC_PAIR('l', 'y'),	"Libya",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'a'),	"Morocco",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'c'),	"Monaco",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'd'),	"Moldova",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'g'),	"Madagascar",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'h'),	"Marshall Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'k'),	"Macedonia",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'l'),	"Mali",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'm'),	"Myanmar",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'n'),	"Mongolia",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'o'),	"Macau",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'p'),	"Northern Mariana Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'q'),	"Martinique",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'r'),	"Mauritania",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 's'),	"Montserrat",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 't'),	"Malta",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'u'),	"Mauritius",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'v'),	"Maldives",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'w'),	"Malawi",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'x'),	"Mexico",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'y'),	"Malaysia",	0L, 0L, 0.0 },
	{ CC_PAIR('m', 'z'),	"Mozambique",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'a'),	"Namibia",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'c'),	"New Caledonia",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'e'),	"Niger",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'f'),	"Norfolk Island",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'g'),	"Nigeria",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'i'),	"Nicaragua",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'l'),	"Netherlands",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'o'),	"Norway",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'p'),	"Nepal",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'r'),	"Nauru",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 't'),	"Neutral Zone",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'u'),	"Niue",	0L, 0L, 0.0 },
	{ CC_PAIR('n', 'z'),	"New Zealand (Aotearoa)",	0L, 0L, 0.0 },
	{ CC_PAIR('o', 'm'),	"Oman",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'a'),	"Panama",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'e'),	"Peru",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'f'),	"French Polynesia",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'g'),	"Papua New Guinea",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'h'),	"Philippines",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'k'),	"Pakistan",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'l'),	"Poland",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'm'),	"St. Pierre and Miquelon",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'n'),	"Pitcairn",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'r'),	"Puerto Rico",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 't'),	"Portugal",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'w'),	"Palau",	0L, 0L, 0.0 },
	{ CC_PAIR('p', 'y'),	"Paraguay",	0L, 0L, 0.0 },
	{ CC_PAIR('q', 'a'),	"Qatar",	0L, 0L, 0.0 },
	{ CC_PAIR('r', 'e'),	"Reunion",	0L, 0L, 0.0 },
	{ CC_PAIR('r', 'o'),	"Romania",	0L, 0L, 0.0 },
	{ CC_PAIR('r', 'u'),	"Russian Federation",	0L, 0L, 0.0 },
	{ CC_PAIR('r', 'w'),	"Rwanda",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'a'),	"Saudi Arabia",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'b'),	"Solomon Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'c'),	"Seychelles",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'd'),	"Sudan",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'e'),	"Sweden",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'g'),	"Singapore",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'h'),	"St. Helena",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'i'),	"Slovenia",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'j'),	"Svalbard and Jan Mayen Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'k'),	"Slovak Republic",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'l'),	"Sierra Leone",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'm'),	"San Marino",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'n'),	"Senegal",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'o'),	"Somalia",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'r'),	"Suriname",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 't'),	"Sao Tome and Principe",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'u'),	"USSR (former)",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'v'),	"El Salvador",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'y'),	"Syria",	0L, 0L, 0.0 },
	{ CC_PAIR('s', 'z'),	"Swaziland",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'c'),	"Turks and Caicos Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'd'),	"Chad",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'f'),	"French Southern Territories",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'g'),	"Togo",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'h'),	"Thailand",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'j'),	"Tajikistan",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'k'),	"Tokelau",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'm'),	"Turkmenistan",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'n'),	"Tunisia",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'o'),	"Tonga",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'p'),	"East Timor",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'r'),	"Turkey",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 't'),	"Trinidad and Tobago",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'v'),	"Tuvalu",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'w'),	"Taiwan",	0L, 0L, 0.0 },
	{ CC_PAIR('t', 'z'),	"Tanzania",	0L, 0L, 0.0 },
	{ CC_PAIR('u', 'a'),	"Ukraine",	0L, 0L, 0.0 },
	{ CC_PAIR('u', 'g'),	"Uganda",	0L, 0L, 0.0 },
	{ CC_PAIR('u', 'k'),	"United Kingdom",	0L, 0L, 0.0 },
	{ CC_PAIR('u', 'm'),	"US Minor Outlying Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('u', 's'),	"United States",	0L, 0L, 0.0 },
	{ CC_PAIR('u', 'y'),	"Uruguay",	0L, 0L, 0.0 },
	{ CC_PAIR('u', 'z'),	"Uzbekistan",	0L, 0L, 0.0 },
	{ CC_PAIR('v', 'a'),	"Vatican City State (Holy See)",	0L, 0L, 0.0 },
	{ CC_PAIR('v', 'c'),	"Saint Vincent and the Grenadines",	0L, 0L, 0.0 },
	{ CC_PAIR('v', 'e'),	"Venezuela",	0L, 0L, 0.0 },
	{ CC_PAIR('v', 'g'),	"Virgin Islands (British)",	0L, 0L, 0.0 },
	{ CC_PAIR('v', 'i'),	"Virgin Islands (U.S.)",	0L, 0L, 0.0 },
	{ CC_PAIR('v', 'n'),	"Viet Nam",	0L, 0L, 0.0 },
	{ CC_PAIR('v', 'u'),	"Vanuatu",	0L, 0L, 0.0 },
	{ CC_PAIR('w', 'f'),	"Wallis and Futuna Islands",	0L, 0L, 0.0 },
	{ CC_PAIR('w', 's'),	"Samoa",	0L, 0L, 0.0 },
	{ CC_PAIR('y', 'e'),	"Yemen",	0L, 0L, 0.0 },
	{ CC_PAIR('y', 't'),	"Mayotte",	0L, 0L, 0.0 },
	{ CC_PAIR('y', 'u'),	"Yugoslavia",	0L, 0L, 0.0 },
	{ CC_PAIR('z', 'a'),	"South Africa",	0L, 0L, 0.0 },
	{ CC_PAIR('z', 'm'),	"Zambia",	0L, 0L, 0.0 },
	{ CC_PAIR('z', 'r'),	"Zaire",	0L, 0L, 0.0 },
	{ CC_PAIR('z', 'w'),	"Zimbabwe",	0L, 0L, 0.0 }
};


u_int addCountry(NLIST * const up, NLIST ** const np, size_t const num) {
	register char *bp, *cp;
	register size_t idx, cnt;
	register u_short cc;

	/* save total unresolved hostnames */
	country[CC_UNRES].count += up->count;
	country[CC_UNRES].nomod += up->nomod;
	country[CC_UNRES].bytes += up->bytes;

	for (cnt=0; cnt < num; cnt++) {
		int ndx = np[cnt]->ishidden;

		if (ndx >= 0 && ndx < MAX_HIDDEN_SITES && hidden_sites[ndx].pfx != NULL)
			bp = hidden_sites[ndx].pfx;
		else	bp = np[cnt]->str;

		if ((cp = strrchr(bp, '.')) == NULL || *++cp == '\0' || *(cp+1) == '\0') {
			prmsg(1, "Skip invalid domain: %s\n", bp);
			continue;
		}

		if (*(cp+2) == '\0') {		/* look up two-letter country code */
			cc = CC_PAIR(cp[0], cp[1]);

			for (idx=CC_START; idx < TABSIZE(country); idx++) {
				if (country[idx].code == cc)
					break;
			}
			if (idx == TABSIZE(country)) {
				idx = CC_OTHER;
				prmsg(1, "unknown top-level-domain: %s\n", cp);
			}
		} else if (cp[0] == 'n' && cp[1] == 'e' && cp[2] == 't')
			idx = CC_NET;
		else if (cp[0] == 'c' && cp[1] == 'o' && cp[2] == 'm')
			idx = CC_USCOM;
		else if (cp[0] == 'e' && cp[1] == 'd' && cp[2] == 'u')
			idx = CC_USEDU;
		else if (cp[0] == 'g' && cp[1] == 'o' && cp[2] == 'v')
			idx = CC_USGOV;
		else if (cp[0] == 'i' && cp[1] == 'n' && cp[2] == 't')
			idx = CC_USMIL;
		else if (cp[0] == 'm' && cp[1] == 'i' && cp[2] == 'l')
			idx = CC_USMIL;
		else if (cp[0] == 'o' && cp[1] == 'r' && cp[2] == 'g')
			idx = CC_USORG;
		else if (cp[0] == 'a' && cp[1] == 'r' && cp[2] == 'p' && cp[3] == 'a')
			idx = CC_USARPA;
		else if (cp[0] == 'n' && cp[1] == 'a' && cp[2] == 't' && cp[3] == 'o')
			idx = CC_USNATO;
		else {
			idx = CC_OTHER;
			prmsg(1, "unknown top-level-domain: %s\n", cp);
		}
		country[idx].count += np[cnt]->count;
		country[idx].nomod += np[cnt]->nomod;
		country[idx].bytes += np[cnt]->bytes;
	}
	return TABSIZE(country);
}

COUNTRY *nextCountry(int const reset) {
	static size_t idx = 0;
	COUNTRY *cp;

	if (reset) {
		idx = 0;
		return NULL;
	}

	for (cp=NULL; !cp && idx < TABSIZE(country); idx++) {
		if (country[idx].count == 0L)
			continue;
		cp = &country[idx];
	}
	return cp;
}

void clearCountry(void) {
	size_t idx;

	for (idx=0; idx < TABSIZE(country); idx++) {
		country[idx].count = country[idx].nomod = 0L;
		country[idx].bytes = 0.0;
	}
	(void) nextCountry(1);		/* reset index */
	return;
}

