// This may look like C code, but it is really -*- C++ -*-

//<copyright>
// 
// Copyright (c) 1994,95
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// original version:
// Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
// Copyright (c) 1991 Silicon Graphics, Inc.
// 
//</copyright>


//<file>
//
// File:        fieldb.h - interface to field browser (r/o field editor)
//
// Created:      7 Apr 94   Michael Pichler
//
// Changed:     13 Apr 95   Michael Pichler
//
//
//</file>


#ifndef harmony_widgets_fieldb_h
#define harmony_widgets_fieldb_h

#include "libwidgets.h"

#include <InterViews/input.h>

class Color;
class EditLabel;
class Patch;
class SelectionManager;
class FieldBrowser_SelectionCallback;
class Style;
class WidgetKit;


//<class>
//
// Name: FieldBrowser
//
// Purpose: Glyph for showing and scrolling a line of text
//
// Style name: FieldBrowser (alias EditLabel)
//
// attributes:
//
// - font            label font
// - foreground      label foreground colour
// - flat            glyph background (inset frame)
// - cursorColor     cursor colour (default: foreground)
// - selectionColor  colour of selection bar (default: foreground)
// - inverseColor    colour of selected char's (default: background)
// - dragDistance    threshold cursor must be moved before dragging is switched on
//
//</class>


class FieldBrowser: public InputHandler
{
  public:
    FieldBrowser(
      WidgetKit*, Style*,               // kit, style
      const char* sample = 0,           // initial string (can be changed with field)
                                        // follwoing arguments usually only set by derived class
      int hide = 0,                     // flag for input hiding
      char hidechar = '\0',             // substitute hide char
      const char* stylename = 0         // style name (default: FieldBrowser)
    );

    virtual ~FieldBrowser();

    virtual void field(const char*);    // set text string

    const char* field() const;          // get current string

    const char* string() const          // (for backward compatibility)
    { return field (); }

    void hidden(int onoff);             // switch on/off input hiding (clears field)
    int hidden() const;                 // get input hiding flag

    // InputHandler
    virtual void undraw();
    virtual void press(const Event&);
    virtual void drag(const Event&);
    virtual void release(const Event&);
    virtual void double_click(const Event&);

    // cut and paste
    void copySelection(const Event&);
    void copy(SelectionManager*);
    virtual void pasteSelection(const Event&)  { }
    void paste(SelectionManager*);
    void lose(SelectionManager*);  // unhighlight

    // allowed operations on underlying editlabel
    void scrollToEnd ();
    void scrollToBegin ();
    // void select (int from, int to);  // not yet implemented

  protected:
    EditLabel* edlabel_;
    Patch* edpatch_;
    const Color* modcolor_;

  private:
    int dblclickindex_;
    int button_;   // mouse button
    Coord dragx_;  // most recent x coordinate
    int dragged_;
    Coord thresh_;
    FieldBrowser_SelectionCallback* copy_;
    FieldBrowser_SelectionCallback* lose_;
    boolean cursor_changed_;

};  // FieldBrowser



#endif
