// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1994,95,96,97
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        stranslate.h
//
// Purpose:     translation of strings for Harmony scene viewer
//
// Created:     29 Mar 94   Michael Pichler
//
// Changed:     27 Feb 97   Michael Pichler
//
// $Id: stranslate.h,v 1.29 1997/02/28 10:33:31 mpichler Exp $
//
//</file>



#ifndef harmony_scene_stranslate_h
#define harmony_scene_stranslate_h


#include <hyperg/hyperg/language.h>



//<class>
//
// Name:       STranslate
//
// Purpose:    translate strings
//
//
//<class>



extern HgLanguage::Language slanguage;



class STranslate
{
  public:

    enum SStrSym
    {
      AboutSCENEVIEWER,
      AboutVERSIONtemplate,
      AboutVERSIONdaemon,
      AboutVERSIONhttp,
      AboutVERSIONvrweb,

      AnchBRIGHTNESS,
      AnchBOUNDINGCUBE,
      AnchCOLORCODE,
      AnchCOLOREDGES,

      AnchorDEFAULTDESTINATION,
      AnchorDEFINEDESTINATION,
      AnchorDEFINESOURCE,
      AnchorDELETE,
      AnchorDESELECT,
      AnchorDISPLAY,
      AnchorFOLLOW,
      AnchorNEXT,
      AnchorPREVIOUS,
//    AnchorSELECTANCHORS,
      AnchorSELECTGROUPS,
      AnchorSELECTOBJECTS,

      AnchorHintACTIVATION,

      ButtonROTATE,
      ButtonSHOWANCHORS,
      ButtonTRANSL,
      ButtonZOOM,

      ColBLACK,
      ColCYAN,
      ColGRAY,
      ColGREEN,
      ColLIGHTGRAY,
      ColMAGENTA,
      ColORANGE,
      ColPURPLE,
      ColREDBROWN,
      ColYELLOW,
      ColWHITE,

      ColorANCHOREDGES,
      ColorANCHORFACES,
      ColorBACKGROUND,
      ColorGLOBALAMBIENT,
      ColorHEADSUP,
      ColorOTHER,
      ColorVIEWINGLIGHT,

      DemoCAR_VW,
      DemoCLOCKTOWER,
      DemoCORVETTE,
      DemoCUBE,
      DemoENGINE,
      DemoIICMFOYER,
      DemoIICMINST,
      DemoKANDHLEIT,
      DemoROOM,
      DemoWORLD,

      DialogButtonOPEN,
      DialogButtonSAVE,

      DialogStringBSPRECALCULATION,
      DialogStringCOLLISIONDISTANCE,
      DialogStringFILENAME,
      DialogStringNAVSPEEDFACTOR,
      DialogStringOVERWRITEEXISTENTFILE,
      DialogStringQUADSLICES,
      DialogStringROTATIONSPEED,
      DialogStringZOOMSPEED,
      DialogStringCONVERGENCEPLANE,
      DialogStringSCREENEYE,

      DialogTitleCOLOURCHOOSER,
      DialogTitleNAVIGATIONSETTINGS,
      DialogTitleOPENFILE,
      DialogTitlePARSEROUTPUT,
      DialogTitleSAVEFILE,

      DisplayBOUNDINGBOX,
      DisplayFLATSHADING,
      DisplayHIDDENLINE,
      DisplayINTERACTIVE,
      DisplaySMOOTHSHADING,
      DisplayTEXTURING,
      DisplayTHESAME,
      DisplayWIREFRAME,

      DocumentANNOTATIONS,
      DocumentATTRIBUTES,
      DocumentPARENTS,
      DocumentREFERENCES,
      DocumentTEXTURES,

      EditCAMERA,
      EditOBJMANIP,
      EditQUIT,

      EditbuttonINSERT,
      EditbuttonANCHOR,
      EditbuttonTEXTURE,
      EditbuttonMATERIAL,
      EditbuttonSTRUCTURE,
      EditbuttonTRANSFORM,
      EditbuttonVIEWPOINT,
      EditbuttonGRID,

      EditdialogINSERTOBJECT,
      EditdialogANCHOREDITOR,
      EditdialogTEXTUREEDITOR,
      EditdialogMATERIALEDITOR,
      EditdialogSTRUCTUREVIEWER,
      EditdialogTRANSFORMEDITOR,
      EditdialogVIEWPOINTSETTINGS,
      EditdialogGRIDSETTINGS,

      FileDEMO,
      FileEDIT,
      FileEXITVIEWER,
      FileEXPORT,
      FileMAIL,
      FileOPEN,
      FilePARSERERRORS,
      FilePRINT,
      FileSAVE,
      FileSAVEAS,
      FileUSABILITYTESTS,

      HARMONY3DVIEWER,
      VRWEBSCENEVIEWER,

      HelpABOUTPRODUCT,
      HelpINDEX,
      HelpOVERVIEW,

      MenuANCHORS,
      MenuCOLOR,
      MenuDISPLAY,
      MenuDOCUMENT,
      MenuFILE,
      MenuHELP,
      MenuNAVIGATE,
      MenuOPTIONS,
      MenuSPECIAL,
      MenuVIEW,
      MenuVIEWPOINTS,

      MessageERRORNOINPUTFILE,
      MessageERRORONREADING,
      MessageERRORONWRITING,
      MessageSUCCESSFULLYWRITTEN,
      MsgboxtitleERROR,

      NavFLIPOBJECT,
      NavFLY,
      NavFLYTO,
      NavHEADSUP,
      NavWALK,

      NavHintFLIPOBJECT,
      NavHintFLY,
      NavHintFLYTO,
      NavHintFLYTOINHU,
      NavHintHEADSUP,
      NavHintWALK,

      NavigateBACK,
      NavigateFORWARD,
      NavigateHISTORY,
      NavigateHOLD,
      NavigateLEVELVIEW,
      NavigateRESETVIEW,
      NavigateUNTILTVIEW,
      NavigateVIEWPOINT,
      NavigateVIEWSELECTION,
      NavigateVIEWWORLD,
      NavigateSETTINGS,
      NavigateSPACEBALL,

      OptionAALIASING,
      OptionAALINES,
      OptionAAPOLYGONS,
      OptionAATEXTURES,
      OptionARBITRARYROTATIONS,
      OptionCOLLISIONDETECTION,
      OptionDOLIGHTING,
      OptionENABLEMOTION,
      OptionNOMATERIALS,
      OptionSHOWFRAMERATE,
      OptionSHOWTITLE,
      OptionTEXTURELIGHTING,
      OptionTRANSPARENCY,
      OptionTWOSIDEDPOLYS,
      OptionVELOCITYCONTROL,

      ProgressCONTACTINGHOST,
      ProgressDATATRANSFER,
      ProgressPROCESSCAMERAS,
      ProgressREADINGACTORS,
      ProgressREADINGCAMERAS,
      ProgressREADINGLIGHTS,
      ProgressREADINGMATERIALS,
      ProgressREADINGOBJECTS,
      ProgressREADINGPOSITIONS,
      ProgressREADINGTEXTURE,
      ProgressREADINGVRML,
      ProgressREADY,
      ProgressREQUESTINLINEVRML,
      ProgressREQUESTTEXTURE,

      RenderRENDERMODE,
      RenderSTEREO,
      RenderZBUFFER,
      RenderBSPTREE,
      RenderBSPPLAIN,
      RenderBSPBACKFACECULLING,
      RenderBSPSHADOWVOLUME,

      SelectSELECTPARENT,
      SelectSELECTCHILD,
      SelectSELECTPREVIOUS,
      SelectSELECTNEXT,

      SpaceballDECREASE,
      SpaceballINCREASE,
      SpaceballRESETSENSITIVITY,
      SpaceballREZERO,
      SpaceballROTATION,
      SpaceballSENSITIVITY,
      SpaceballSINGLEAXISFILTER,
      SpaceballTRANSLATION,

      StatuslineBSPTREE,
      StatuslineBSP_BACKFACES,
      StatuslineBSP_HIDDENFACES,
      StatuslineBSP_VISIBLEFACES,
      StatuslineFPS,
      StatuslineLASTFRAME,
      StatuslinePOLYGONS,
      StatuslinePRIMITIVES,
      StatuslineTEXTURED,

      SpecialCAMERAINFO,
      SpecialPRINTALL,
      SpecialPRINTDATA,

      TransparBLENDING,
      TransparSTIPPLE,

      TwosidedAUTO,
      TwosidedOFF,
      TwosidedON,

      UTestEAST,
      UTestNORTH,
      UTestSOUTH,
      UTestWEST,

      NumStrings  // number of defined strings
    };

    static const char* str(             // get a string
      SStrSym strsym,                   //   symbolic string constant
      HgLanguage::Language language = slanguage  // language
                                        //   default: global language
    );
}; // STranslate


#endif
