/*
**	SWISH++
**	entities.h
**
**	Copyright (C) 1998  Paul J. Lucas
**
**	This program is free software; you can redistribute it and/or modify
**	it under the terms of the GNU General Public License as published by
**	the Free Software Foundation; either version 2 of the License, or
**	(at your option) any later version.
** 
**	This program is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
** 
**	You should have received a copy of the GNU General Public License
**	along with this program; if not, write to the Free Software
**	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef	entities_H
#define	entities_H

// standard
#ifdef HASH
#	include <hash_map>
#	define MAP hash_map
#else
#	include <map>
#	define MAP map
#endif

// local
#include "less.h"

//*****************************************************************************
//
// SYNOPSIS
//
	class entity_map
//
// DESCRIPTION
//
//	An entity_map is used to perform fast look-up of a character entity
//	reference.  It uses char const* to point directly to the C-strings in
//	the entity_table[] vector; no strings are copied.
//
// SEE ALSO
//
//	entites.c	entity_table[]
//	html.c		convert_entity()
//
//*****************************************************************************
{
public:
	typedef char const* key_type;
	typedef char value_type;

	entity_map();

	value_type operator[]( key_type key ) const {
		map_type::const_iterator i = map_.find( key );
		return i != map_.end() ? i->second : ' ';
	}
private:
	typedef std::MAP< key_type, value_type > map_type;
	map_type map_;
};

#endif	/* entities_H */
