/*
 * system.h
 *
 * shared system header with the whole package
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97, 98 Akim Demaille, Miguel Santana
 * $Id: system.h,v 1.4 1998/02/23 14:51:46 demaille Exp $
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _SYSTEM_H_
#define _SYSTEM_H_

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>

/* Support of prototyping when possible */
#ifndef PARAMS
#  if PROTOTYPES
#    define PARAMS(protos) protos
#  else /* no PROTOTYPES */
#    define PARAMS(protos) ()
#  endif /* no PROTOTYPES */
#endif

#include "xstdlib.h"
#include "xstring.h"

#ifdef HAVE_MATH_H
#  include <math.h>
#else
extern double atan2 PARAMS ((double, double));
#endif

#ifdef HAVE_ERRNO_H
#  include <errno.h>
#endif
#ifndef errno
extern int errno;
#endif

#include <ctype.h>
#include "xsysstat.h"	/* Includes sys/types and sys/stat */
#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
# define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

#ifdef HAVE_PWD_H
#  include <pwd.h>
#endif

#include "xunistd.h"	/* Includes sys/types */

#if TIME_WITH_SYS_TIME
#  include <time.h>
#  include <sys/time.h>
#else 
#  ifdef HAVE_SYS_TIME_H
#    include <sys/time.h>
#  else
#    include <time.h>
#  endif
#endif

/*
 *	Internationalization stuff
 */
#include "xnls.h"
#include "xmalloc.h"
#include "error.h"

/*
 * Missing functions
 */
#ifndef HAVE_STRCOLL
#  define strcoll strcmp
#endif

#ifndef HAVE_TEMPNAM
#  define tempnam(_dir_,_pfx_) tmpnam(NULL)
#endif

/*
 * More defines
 */
#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS	0
#endif
#ifndef EXIT_FAILURE
#  define EXIT_FAILURE	1
#endif
#ifndef NULL
#  define NULL		0
#endif
#ifndef NUL
#  define NUL		'\0'
#endif

#define cardinalityof(ARRAY) (sizeof (ARRAY) / sizeof ((ARRAY)[0]))

#endif /* !defined (_SYSTEM_H_) */
