/* "hardware.c" copyright 1994 thomas insel 
 *              copyrighy 1995 sven oliver moll */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string.h>

#ifdef sun
#  include <sundev/srreg.h>
#elif defined linux
#  include <linux/cdrom.h>
#else
#  errror Please fix includes for your system in hardware.c
#endif

#include "config.h"
#include "database.h"
#include "hardware.h"

/* WWH hack to get rid of malloc/free's */
#ifdef CDCTRL
cdhw_t strHW;
#endif

cdhw_t *
read_hw(char *progname, int cdfile)
{
  int i;
#ifdef CDCTRL
  cdhw_t *hw = &strHW;
#else
  cdhw_t *hw = malloc(sizeof(cdhw_t));
#endif

#ifdef DEBUG
  fprintf (stderr, "read_hw buffer=%ld\n", (void *)hw);
#endif

  /* read header */
  if ( ioctl(cdfile, CDROMREADTOCHDR, &(hw->tochdr)) == -1 ) 
    {
      fprintf(stderr, "%s: ioctl cdromreadtochdr\n", progname);
#ifdef CDCTRL
      hw->subchnl.cdsc_audiostatus = CDROM_AUDIO_ERROR;
      return (hw);
#else
      EXIT(1);
#endif
    }

  /* read individual tracks */
  for (i=hw->tochdr.cdth_trk0-1; i<=hw->tochdr.cdth_trk1; i++) 
    {
      hw->tocentries[i].cdte_track=
	(i==hw->tochdr.cdth_trk1) ? CDROM_LEADOUT : i+1;
      
      hw->tocentries[i].cdte_format = CDROM_MSF;
      if ( ioctl(cdfile, CDROMREADTOCENTRY, &(hw->tocentries[i])) == -1 )
	{
	  fprintf(stderr, "%s: ioctl cdromreadtocentry\n", progname);
#ifdef CDCTRL
	  hw->subchnl.cdsc_audiostatus = CDROM_AUDIO_ERROR;
	  return (hw);
#else
	  EXIT(1);
#endif
        }
    }

  /* read subchannel info */
  hw->subchnl.cdsc_format = CDROM_MSF;
  if ( ioctl(cdfile, CDROMSUBCHNL, &(hw->subchnl)) == -1 ) 
    {
      fprintf(stderr, "%s: ioctl cdromsubchnl\n", progname);
#ifdef CDCTRL
      hw->subchnl.cdsc_audiostatus = CDROM_AUDIO_ERROR;
      return (hw);
#else
      EXIT(1);
#endif
    }

  return hw;

}

void free_hw_buf(cdhw_t *pHw)
{

#ifdef DEBUG
    fprintf (stderr,"free_hw_buf:  bufp=0x%lx\n", (char *)pHw);
#endif

#ifndef CDCTRL

    if ((void *)pHw != NULL)
	free ((void *)pHw);
#endif
}
