/* filename: rlpr-msg.h
 * project: rlpr
 * author: meem  --  meem@sherilyn.wustl.edu
 * version: $Id: rlpr-msg.h,v 1.1 1997/02/22 07:16:59 meem Exp meem $
 * contents: header for rlpr's messaging facility
 *
 * Time-stamp: <1997/04/27 01:05:05 cdt -- meem@sherilyn.wustl.edu>
 */

#ifndef RLPR_MSG_H
#define RLPR_MSG_H

#include <stdarg.h>

enum rlpr_msg_level { DEBUG, INFO, WARNING, FATAL };
enum rlpr_msg_errno { NO_ERRNO, ERRNO             };
enum rlpr_msg_field { RLPR_MSG_QUIET, RLPR_MSG_DEBUG, RLPR_MSG_SYSLOG };

/* these are properties of each application that the rlpr_msg facility
 * requires.  the application should be unconcerned entirely with
 * them.  to make parsing of the commandline options for rlpr_msg_info
 * things transparent to rlpr applications which use it, they can call
 * rlpr_msg_init(), which takes in argv and argc, and sets rlpr_msg's
 * internal rlpr_msg_info struct appropriately.  it does not hurt argv
 * or argc.  if argv[] is NULL then the commandline is not evaluated
 *
 * additionally, individual elements can be set with rlpr_msg_set()
 */

extern char * program_name;

typedef struct rlpr_msg_info {
  char          quiet;        /* application stays quiet               */
  char          debug;        /* application is in debug mode          */
  char          syslog;       /* application posts diag msgs to syslog */
} rlpr_msg_info;

void       rlpr_msg(enum rlpr_msg_level, enum rlpr_msg_errno, char *, ...);
void  rlpr_msg_args(int argc, char * const argv[]);
int    rlpr_msg_set(enum rlpr_msg_field, void * value);
void * rlpr_msg_get(enum rlpr_msg_field field);

#endif /* RLPR_MSG_H */
