!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  macros.inc
!* Purpose: Miscellanous assembler macros
!* Entries: None
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Define the processor type to use
!
#ifdef P86
	use16	86		! use only 8086 instructions
#else
# ifdef P186
	use16	186		! may also use 80186 special instructions
#	define	IS186
# else
#  ifdef P286
	use16	286		! may also use 80286 special instructions
#	define	IS186
#	define	IS286
#  else
	use16	386		! this is the default
#	define	IS186
#	define	IS286
#	define	IS386
#  endif
# endif
#endif

#if defined(IS386) && defined(OPTIMIZE)
#	define OPT386
#endif


!
!**************************************************************************
!
! Macros to make things easier with higher processors
!
! Standard shift and rotate instructions
!
macro	shift

#ifdef IS186
		?1	?2,#?3
#else
	if ?3 > 1
		push	cx
		mov	cl,#?3
		?1	?2,cl
		pop	cx
	else
		?1	?2,#1
	endif
#endif

mend


!
! Push all registers onto stack
! 
macro	pushall

#ifdef IS186
		pusha
#else
		push	ax
		push	cx
		push	dx
		push	bx
		push	sp
		push	bp
		push	si
		push	di
#endif

mend


!
! Pop all registers from stack
! 
macro	popall

#ifdef IS186
		popa
#else
		pop	di
		pop	si
		pop	bp
		pop	ax		! SP is discarded
		pop	bx
		pop	dx
		pop	cx
		pop	ax
#endif

mend


!
! Setup standard stackframe
!
macro	penter

		push	bp
		mov	bp,sp

mend


!
! Terminate standard stackframe
!
macro	pleave

		pop	bp

mend


!
! Get an argument from the stack using a constant argument number
!
macro	getcarg

		mov	?1,[bp + (?2 * 2) + 4]

mend


#ifdef IS386
!
! Get an argument into a 386 32-bit register
!
macro	getlarg

		movzx	?1,?3 ptr [bp + (?2 * 2) + 4]

mend
#endif


!
! Get an argument from the stack using an argument number in a register
!
macro	getrarg

	ifc (?1,si)
		mov	si,?2
		shl	si,#1
		mov	si,[bp + si + 4]
	else
		push	si
		mov	si,?2
		shl	si,#1
		mov	?1,[bp + si + 4]
		pop	si
	endif

mend

