/* Library extensions for nwdir.c */

#include <nwcalls.h>
#include "ncplib_err.h"

NWCCODE NWCallsInit(void* dummy1, void* dummy2) {
	(void)dummy1;
	(void)dummy2;
	return 0;
}

NWCCODE NWRequest(NWCONN_HANDLE conn, nuint function, 
	nuint numRq, const NW_FRAGMENT* rq, 
	nuint numRp, NW_FRAGMENT* rp) {
	long result;
	nuint i;
	size_t rest;
	unsigned char* ptr;

	ncp_init_request(conn);
	for (i=numRq; i--; rq++) {
		ncp_add_mem(conn, rq->fragAddress, rq->fragSize);
	}
	result = ncp_request(conn, function);
	if (result) {
		if (result == NCPL_ET_REQUEST_ERROR) {
			result = 0x8900 | (conn->completion);
		} else {
			result = 0x88FF;
		}
		ncp_unlock_conn(conn);
		return result;
	}
	rest = conn->ncp_reply_size;
	ptr = ncp_reply_data(conn, 0);
	for (i=numRp; i--; rp++) {
		size_t spc = rp->fragSize;
		if (spc > rest) {
			memcpy(rp->fragAddress, ptr, rest);
			/* Do we want to modify fragList ? */
			/* I think so because of we want to propagate */
			/* reply length back to client */
			/* maybe we could do "return conn->ncp_reply_size" */
			/* instead of "return 0". */
			rp->fragSize = rest;
			rest = 0;
		} else {
			memcpy(rp->fragAddress, ptr, spc);
			rest -= spc;
		}
	}
	ncp_unlock_conn(conn);
	return 0;
}

NWCCODE NWGetObjectName(NWCONN_HANDLE conn, nuint32 ID, char* name, nuint16* type) {
	long result;
	struct ncp_bindery_object spc;

	result = ncp_get_bindery_object_name(conn, ID, &spc);
	if (result == NCPL_ET_REQUEST_ERROR) {
		return 0x89FF;
	}
	if (result) return 0x88FF;
	if (name) strncpy(name, spc.object_name, NCP_BINDERY_NAME_LEN);
	if (type) *type = spc.object_type;
	return 0;
}

NWCCODE NWGetNSEntryInfo(NWCONN_HANDLE conn, nuint dirHandle, const char* path, 
	nuint srcNS, nuint dstNS, nuint16 attr, nuint32 rim, NW_ENTRY_INFO* info) {
	unsigned char buff[1024];
	int rslt;

	rslt = ncp_path_to_NW_format(path, buff, sizeof(buff));
	if (rslt < 0) return rslt;
	rslt = ncp_obtain_file_or_subdir_info2(conn, srcNS, dstNS, attr, rim, 
		dirHandle?0:0xFF, 0, dirHandle, buff, rslt, info);
	if (rslt == NCPL_ET_REQUEST_ERROR) return 0x89FF;
	if (rslt) return 0x88FF;
	return 0;
}

NWCCODE NWParsePath(const char* path, char* server, NWCONN_HANDLE* conn, 
	char* volume, char* volpath) {
	long result;
	NWCONN_HANDLE cn;
	char tmp[1000];
	char* ptr;

	result = ncp_open_mount(path, &cn);
	if (result) {
		if (volume)
			*volume = 0;
		if (volpath)
			strcpy(volpath, path);
		if (conn)
			*conn = NULL;
		return 0;
	}
	result = ncp_ns_get_full_name(cn, NW_NS_DOS, NW_NS_DOS, 1,
		cn->i.volume_number, cn->i.directory_id, NULL, 0, tmp, sizeof(tmp));
	if (result) {
		return 0x89FF;
	}
	ptr = strchr(tmp, ':');
	if (ptr) {
		if (volume) {
			memcpy(volume, tmp, ptr-tmp);
			volume[ptr-tmp]=0;
		}
		if (volpath)
			strcpy(volpath, ptr+1);
	} else {
		if (volume)
			*volume = 0;
		if (volpath)
			strcpy(volpath, tmp);
	}
	if (conn)
		*conn = cn;
	return 0;
}

