/*
 * all prototypes
 */
					/* main.c : */
extern XtInputId register_X_input();	/* tell X about new server connection*/
extern void unregister_X_input();	/* tell X when server conn. is down */
extern void resynchronize_daemon();	/* tell daemon to re-read database */
extern void set_color();		/* set foregnd color to one of COL_* */
extern void print_pixmap();		/* prints pixmap into a Pixmap label */
extern void get_rsrc();			/* read resource */
extern char *mystrdup();		/* strdup replacement for Ultrix */
extern void exit();			/* local version of exit w/ writeback*/
#ifndef VARARGS
extern void fatal(char *fmt, ...);	/* print error message and exits */
extern void print_button(Widget w, char *fmt, ...);
extern void print_text_button(Widget w, char *fmt, ...);
#else
extern void fatal();			/* prints an error message and exits */
extern void print_button();		/* print a string into label or but */
extern void print_text_button();	/* print a string into a Text button */
#endif

					/* convert.c : */
extern char *mkdatestring();		/* convert # of seconds to a date */
extern char *mktimestring();		/* convert # of seconds to a t-o-d */
extern time_t parse_datestring();	/* convert date string to # of secs */
extern time_t parse_timestring();	/* convert time string to # of secs */
extern time_t parse_datetimestring();	/* convert date+time to # of secs */
extern void parse_warnstring();		/* early/late warning time, noalarm */

					/* cyccalc.c : */
extern time_t length_of_month();	/* # of days in the month <time> */
extern BOOL recycle_all();		/* recycle all entries in <list> */
extern int  recycle();			/* get next repeating trigger time */

					/* dayedit.c : */
extern void got_entry_press();		/* pressed on list menu button array */
extern void confirm_new_entry();	/* put edited row back into mainlist */
extern void undo_new_entry();		/* Kill the edit buffer, undo */
extern void got_entry_text();		/* user entered text into text button*/
extern void sensitize_edit_buttons();	/* change bottom row */

					/* dbase.c : */
extern int  name_to_user();		/* user name to index into user[] */
extern int  add_entry();		/* add an entry to a list */
extern int  resort_entry();		/* move an entry to its proper place */
extern int  find_next_trigger(); 	/* find next alarm/warn trigger time */
extern void create_list();		/* start a new list */
extern void destroy_list();		/* delete a list. */
extern void delete_entry();		/* delete an entry from the list. */
extern void clone_entry();		/* copy one entry to another */
extern void rebuild_repeat_chain();	/* chain all repeating entries */
extern void destroy_entry();		/* free all strings of an entry */
extern BOOL lookup_entry(); 		/* find an entry in the list by date */
extern BOOL lookup_next_entry();	/* find the next entry */

					/* file_r.c : */
extern BOOL read_mainlist();		/* read all files into mainlist */
extern void parse_file_line();		/* parse one line from appt file */

					/* file_w.c : */
extern BOOL copyfile();			/* copy one file to another */
extern void write_mainlist();		/* write all modified files */
extern int  write_one_entry();		/* write one entry to file or server */

					/* help.c : */
extern void help_callback();		/* print help for a topic */

					/* holiday.c : */
extern char *parse_holidays();		/* eval holiday defs for <year> */
extern void seteaster();		/* set a holiday relative to Easter */
extern void setdate();			/* set holiday by date */
extern void setwday();			/* set holiday by weekday */
extern void setdoff();			/* set holiday by weekday date offset*/

					/* lock.c : */
extern char *resolve_tilde();		/* return path with ~ replaced */
extern BOOL find_file();		/* find file <name> and store path */
extern BOOL startup_lock();		/* make sure program runs only once */
extern char *mystrdup();		/* local version of strdup */
extern int mystrcasecmp();		/* local version of strcasecmp */
#ifndef VARARGS
extern void fatal(char *, ...);		/* print fatal error message and exit*/
#else
extern void fatal();			/* print fatal error message and exit*/
#endif

					/* pixmap.c : */
extern void init_pixmaps();		/* intialize pixmaps for mode buttons*/
extern void print_icon_name();		/* change the name below the icon */
extern void set_icon();			/* set icon for the application */
extern int strlen_in_pixels();		/* return length of string in pixels */
extern void truncate_string();		/* truncate string to fit into n pixs*/

					/* popup.c : */
extern void create_about_popup();	/* create About info popup */
extern void create_nodaemon_popup();	/* create no-daemon warning popup */
extern void create_multiple_popup();	/* create multiple-plan's warning */
extern void multiple_writer_warning_popup(); /* create write warning popup */
#ifndef VARARGS
extern void create_error_popup(Widget widget, int error, char *fmt, ...);
#else
extern void create_error_popup();	/* create error popup with Unix error*/
#endif

					/* print.c : */
extern void create_print_popup();	/* create a print popup */

					/* sublist.c : */
extern void create_sublist();		/* create a sublist for list menu */
extern void destroy_sublist();		/* destroy the sublist of a list menu*/

					/* time.c : */
extern void set_tzone();		/* figure out current timezone */
extern void guess_tzone();		/* guess timezone from $TZ */
extern time_t tm_to_time();		/* convert tm struct to seconds */
extern time_t get_time();		/* current time in seconds */
extern time_t date_to_time();		/* day/month/year as # of secs */
extern struct tm *time_to_tm();		/* seconds to tm struct */

					/* weekcalc.c : */
extern void build_week();		/* week node tree for curr_week */
extern void destroy_week();		/* release the week node trees. */

					/* yovcalc.c : */
extern void build_yov();		/* week node tree for curr_week */
extern void destroy_yov();		/* release the week node trees. */

					/* daycalc.c : */
extern void build_day();		/* week node tree for curr_day */
extern void destroy_day();		/* release the day node trees. */

					/* adjmenu.c : */
extern void create_adjust_popup();	/* create an adjust popup */

					/* advmenu.c : */
extern void destroy_advance_popup();	/* destroy a popup */
extern void create_advance_popup();	/* create an advance-warning popup */

					/* calmenu.c : */
extern void create_cal_widgets();	/* create the main calendar window */
extern void create_view();		/* create a new month/week/... view */
extern Widget create_view_form();	/* make a window or form for a view */
extern void redraw_all_views();		/* refraw all existing views */
extern void get_widget_size();		/* get the size of a widget */
extern void set_widget_size();		/* set the size of a widget */

					/* cnfmenu.c : */
extern void create_config_popup();	/* create a config popup */

					/* cycmenu.c : */
extern void destroy_recycle_popup();	/* destroy a popup */
extern void create_recycle_popup();	/* create a recycle popup */

					/* daymenu.c : */
extern void destroy_all_listmenus();	/* destroy all list menus */
extern void update_all_listmenus();	/* redraw all list menus */
extern void create_entry_widgets();	/* creates all widgets in a list menu*/
extern void edit_list_button();		/* turn text button to label or back */
extern void create_list_popup();	/* create a list popup */
extern BOOL prepare_for_modify();	/* check if user file is writable */

					/* excmenu.c : */
extern void destroy_except_popup();	/* destroy a popup */
extern void create_except_popup();	/* create an exception */

					/* gotomenu.c : */
extern void create_goto_popup();	/* create a goto popup */

					/* holmenu.c : */
extern void create_holiday_popup();	/* create a holiday popup */

					/* keymenu.c : */
extern void  create_keyword_popup();	/* create a keyword popup */

					/* monmenu.c : */
extern void destroy_month_view();	/* destroy month view */
extern void create_month_view();	/* create month view */

					/* msgmenu.c : */
extern void destroy_text_popup();	/* destroy a popup */
extern void create_text_popup();	/* create a message or script popup */

					/* notmenu.c : */
extern void create_widgets();

					/* rangemenu.c : */
extern void create_calconfig_popup();	/* create a week view range popup */

					/* usermenu.c : */
extern BOOL all_files_served();		/* all files read from IP servers? */
extern void create_user_popup();	/* create user popup */

					/* weekmenu.c : */
extern void create_week_menu();		/* create the week menu for curr_week*/

					/* yearmenu.c : */
extern void destroy_year_menu();	/* destroy the year window */
extern void create_year_menu();		/* create year calendar for curr_year*/

					/* daymenu.c : */
extern void create_day_menu();		/* create the day menu for curr_day */

					/* editdraw.c : */
extern void draw_list();		/* draw or redraw a list of entries */
extern char *mkbuttonstring();		/* string to draw into a text button */
extern char *mknotestring();		/* return string to draw into note */
extern BOOL show_except_pixmap();	/* should appt show PIC_EXCEPT? */

					/* mondraw.c : */
extern void clicked_calendar();		/* press in calendar day box */
extern void draw_month_year();		/* draw month and year into calendar */
extern void draw_calendar();		/* draw day grid into main calendar */
extern void draw_day();			/* draw one day box into the day grid*/
extern void truncate_string();		/* truncate <string> */

					/* weekdraw.c : */
extern void clicked_week_calendar();	/* press on the week display detected*/
extern void draw_week_day();		/* day d/m/y has changed, redraw week*/
extern void draw_week_calendar();	/* resize and redraw week menu */
extern void print_week_calendar();	/* print PostScript week to fp */

					/* daydraw.c : */
extern void clicked_day_calendar();	/* press on the day display detected */
extern void draw_day_calendar();	/* resize and redraw day menu */
extern void print_day_calendar();	/* print PostScript day to fp */

					/* yovdraw.c : */
extern void clicked_yov_calendar();	/* press on the yov display detected */
extern void draw_yov_calendar();	/* resize and redraw yov menu */
extern void print_yov_calendar();	/* print PostScript yov to fp */

					/* yeardraw.c : */
extern void draw_year_calendar();	/* draw day grid into year cal */
extern void draw_year_day();		/* draw one day box into year cal */
extern int  clicked_year_calendar();	/* got a click in the calendar area */

					/* psdraw.c : */
extern BOOL g_init_window();		/* init week/yov window drawing */
extern void g_exit_window();		/* finish week/yov window drawing */
extern void g_init_ps();		/* init week/yov PostScript drawing */
extern void g_exit_ps();		/* finish week/yov PostScript drawing*/
extern void g_setcolor();		/* select COL_* color */
extern void g_setfont();		/* select FONT_* font */
extern void g_fillrect();		/* draw filled rectangle */
extern void g_drawtext();		/* draw latin text string */
extern void g_drawtext16();		/* draw Japanese text string */
extern void g_drawpoly();		/* draw filled polygon */
extern void g_drawlines();		/* draw connected lines */

					/* network.c : */
extern BOOL can_edit_appts();		/* ok to edit appointments? */
extern char *attach_to_network();	/* (re)connect to net, reread appts */
extern void detach_from_network();	/* disconnect from all servers */
extern int  name_to_file();		/* convert file/user name to file ID */
extern BOOL server_entry_op();		/* link, unlink, delete, send entry */
extern void read_from_server();		/* read one or all appointments */
extern BOOL puts_server();		/* send message to a server */
extern BOOL gets_server();		/* receive message from server */


/*
 * grok prototypes
 */

/*---------------------------------------- g_dbase.c ------------*/

struct dbase *dbase_create(void);
void dbase_delete(
	struct dbase	*dbase);	/* dbase to delete */
BOOL dbase_addrow(
	int		*rowp,		/* ptr to returned row number */
	struct dbase	*dbase);	/* database to add row to */
void dbase_delrow(
	int		nrow,		/* row to delete */
	struct dbase	*dbase);	/* database to delete row in */
char *dbase_get(
	struct dbase	*dbase,		/* database to get string from */
	int		nrow,		/* row to get */
	int		ncolumn);	/* column to get */
BOOL dbase_put(
	struct dbase	*dbase,		/* database to put into */
	int		nrow,		/* row to put into */
	int		ncolumn,	/* column to put into */
	char		*data);		/* string to store */

/*---------------------------------------- g_dbfile.c ------------*/

BOOL write_dbase(
	struct dbase	*dbase,		/* form and items to write */
	struct form	*form,		/* contains column delimiter */
	BOOL		force);		/* write even if not modified*/
BOOL read_dbase(
	struct dbase	*dbase,		/* form and items to write */
	struct form	*form,		/* contains column delimiter */
	char		*path);		/* file to read list from */

/*---------------------------------------- g_formfile.c ------------*/

BOOL write_form(
	struct form	*form);		/* form and items to write */
BOOL read_form(
	struct form	*form,		/* form and items to write */
	char		*path);		/* file to read list from */

/*---------------------------------------- g_formop.c ------------*/

struct form *form_create(void);
struct form *form_clone(
	struct form	*parent);	/* old form */
void form_delete(
	struct form	*form);		/* form to delete */
BOOL verify_form(
	struct form	*form,		/* form to verify */
	int		*bug,		/* retuirned buggy item # */
	Widget		shell);		/* error popup parent */
void form_edit_script(
	struct form	*form,		/* form to edit */
	Widget		shell,		/* error popup parent */
	char		*fname);	/* file name of script (dbase name) */
void form_sort(
	struct form	*form);		/* form to sort */
void item_deselect(
	struct form	*form);		/* describes form and all items in it*/
BOOL item_create(
	struct form	*form,		/* describes form and all items in it*/
	int		nitem);		/* the current item, insert point */
void item_delete(
	struct form	*form,		/* describes form and all items in it*/
	int		nitem);		/* the current item, insert point */
struct item *item_clone(
	struct item	*parent);	/* item to clone */
