#include "defs.h"


extern Frame   frame;
extern Display *display;
extern int     dsp_width, dsp_height;



Frame  BarFrame;
Panel  BarPanel, BarGraph;

int    LastValue = 0;





void SetBarGraph(double value)
{
  int perc;

  perc = (int) (value * 100);
  if (value < 0) perc =   0;
  if (value > 1) perc = 100;

  if (LastValue == perc) return;

  xv_set(BarGraph, PANEL_VALUE, perc, NULL);
  XFlush(display);

  LastValue = perc;
}


void CreateBarGraph()
{
  int    BarWidth =  300;
  int    BarHeight =  80;


  BarFrame = (Frame) xv_create(frame,                  FRAME_CMD,
			       XV_WIDTH,                10,
			       XV_HEIGHT,               10,
			       FRAME_LABEL,            BarWindowHeader,
			       NULL);

  BarPanel = (Panel) xv_create(BarFrame,               PANEL,
			       XV_X,                    10,
			       XV_Y,                    10,
			       NULL);

  xv_create(BarPanel,           PANEL_MESSAGE,
	    XV_X,               5,
	    XV_Y,               5,
	    PANEL_LABEL_BOLD,   TRUE,
	    PANEL_LABEL_STRING, "Transfering GPS data:",
	    NULL);

  xv_create(BarPanel,           PANEL_MESSAGE,
	    XV_X,               300,
	    XV_Y,                 5,
	    PANEL_LABEL_BOLD,   TRUE,
	    PANEL_LABEL_STRING, "",
	    NULL);


  BarGraph = (Panel) xv_create(BarPanel,               PANEL_GAUGE,
			       XV_Y,                    50,
			       XV_X,                    50,
			       PANEL_MIN_VALUE,          0,
			       PANEL_MAX_VALUE,        100,
			       PANEL_GAUGE_WIDTH,      200,
			       PANEL_LABEL_STRING,     "",
			       PANEL_DIRECTION,        PANEL_HORIZONTAL,
			       PANEL_MIN_TICK_STRING,    "0%",
			       PANEL_MAX_TICK_STRING,  "100%",
			       PANEL_VALUE,            0,
			       NULL);

  window_fit(BarPanel);
  window_fit(BarFrame);

  
  xv_set(BarFrame, XV_X, (int) ((dsp_width - BarWidth) / 2),
	           XV_Y, (int) ((dsp_height / 2) - (BarHeight / 2)),
	 NULL);

  xv_set(BarFrame, XV_SHOW, TRUE, NULL);
  xv_set(BarFrame, XV_SHOW, FALSE, NULL);
  XFlush(display);
  sleep(1);
}


void InitBarGraph()
{
  xv_set(BarFrame, XV_SHOW,              TRUE,
                   FRAME_CMD_PUSHPIN_IN, TRUE,
	           NULL);
  XFlush(display);
  sleep(1);
}


void CloseBarGraph()
{	
  xv_set(BarFrame, FRAME_CMD_PUSHPIN_IN, FALSE,
	           XV_SHOW,              FALSE,
	           NULL);

}
