#!/usr/local/bin/perl
#  memorized.pl - functions to implement memorized transactions
#
#  Written by Curtis Olson.  Started October 13, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: memorized.pl,v 2.8 1997/04/11 20:24:02 curt Exp $
# (Log is kept at end of this file)

package CBB;

use strict;    # don't take no guff


# WARNING:  This file must be "required" after the main transaction file.

# %CBB::MEMS - an associative array of transactions and description keys
# @CBB::MEMKEYS - a sorted list of description keys (for memorized transactions)


# initialize the memorized transaction list
sub init_mems {
    # out: result

    %CBB::MEMS = ();
    $CBB::sorted_memkeys = 1;

    return "ok";
}


# insert a memorized transaction into the MEMS list
sub insert_mem {
    # in: trans
    # out: trans

    my($trans) = @_;
    my($date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total) =
	split(/\t/, $trans);

    $CBB::MEMS{$desc} = $trans;

    print DEBUG "insert_mem:  $desc -> $trans\n" if $CBB::debug;

    return "$trans";
}


# insert a memorized transaction into the MEMS list *AND* rebuild the MEMKEYS
sub insert_and_update_mem {
    # in: trans
    # out: trans

    my($trans) = @_;
    my($date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total) =
	split(/\t/, $trans);

    $CBB::MEMS{$desc} = $trans;
    @CBB::MEMKEYS = sort(keys %CBB::MEMS);

    print DEBUG "insert_mem:  $desc -> $trans\n" if $CBB::debug;

    return "$trans";
}


# build the MEMS list
sub rehash_mems {
    # out: result

    my($key);

    &init_mems();

    if ($CBB::calced == 0) {
	&calc_trans();
    }

    if ($CBB::sorted_keys == 0) {
	&sort_keys();
    }

    foreach $key (@CBB::KEYS) {
	&insert_mem($CBB::TRANS{$key});
    }

    @CBB::MEMKEYS = sort(keys %CBB::MEMS);

    return "ok";
}


# attempt to find a transaction matching the description
# incomplete descriptions are allowed
sub find_mem {
    # in: desc
    # out: trans

    my($desc) = @_;
    my($result, $count, $i, $match, $memkey);

    if ( $desc ne "" ) {
	$count = 0;
	$match = 0;

        foreach $memkey (@CBB::MEMKEYS) {
	    if ( $memkey =~ m/^$desc/i ) {
		print DEBUG "$memkey <=> $desc\n" if $CBB::debug;

		$count++;

		if ( $memkey =~ m/^$desc$/i ) {
		    print DEBUG "exact match $memkey <=> $desc\n" 
			if $CBB::debug;
		    $match = 1;
		}

	        if ( length($result) ) {
		    $i = 0;
		    while ( $i < length($result) &&
			    substr("\U$result", $i, 1) eq 
			    substr("\U$memkey", $i, 1) ) {
			$i++;
		    }
		    $result = substr($result, 0, $i);
	        } else {
	            $result = $memkey
		}
	    }
        }
	if ( length($result) && ($count == 1) ) {
	    return "$desc\t$CBB::MEMS{$result}";
	} elsif ( $match ) {
	    return "$desc\t$CBB::MEMS{$result}";
	} elsif ( length($result) ) {
	    return "partial_match:$result";
	}
    }

    return "none";
}


&init_mems();


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: memorized.pl,v $
# Revision 2.8  1997/04/11 20:24:02  curt
# Automatically insert new transactions into the memorized list.
#
# Revision 2.7  1997/01/18 03:28:45  curt
# Added "use strict" pragma to enforce good scoping habits.
#
# Revision 2.6  1996/12/17 14:54:01  curt
# Updated copyright date.
#
# Revision 2.5  1996/10/22 21:51:10  curt
# Tweaked tab completion just a bit more.
#
# Revision 2.4  1996/09/26 19:48:45  curt
# Fixed some problems with the newly revamped tab completion code.
#
# Revision 2.3  1996/09/25 17:11:10  curt
# Added some initial code to better handle tab completion.
#
# Revision 2.2  1996/07/13 02:57:50  curt
# Version 0.65
# Packing Changes
# Documenation changes
# Changes to handle a value in both debit and credit fields.
#
# Revision 2.1  1996/02/27  05:35:49  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:43:02  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
