/*
   Siag, Scheme In A Grid
   Copyright (C) 1996-1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "../siod/siod.h"

#include "../siag/types.h"
#include "../siag/calc.h"

#include "gsiag.h"

enum {ABORT = 0, DONE, WAITING};

static char filename_buffer[1024];
static GtkWidget *file_dialog = NULL;
static int status;

static void fsel_done(GtkWidget *w, GtkFileSelection *fs)
{
	strcpy(filename_buffer, gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
	status = DONE;
}

static void fsel_abort(GtkWidget *w, GtkWidget **window)
{
	status = ABORT;
}

int select_file(char *path, char *name, char *patterns[], char *fmt)
{
	int format, nchoices;
	if (!file_dialog) {
		file_dialog = gtk_file_selection_new("Select File");
		gtk_window_position (GTK_WINDOW (file_dialog), GTK_WIN_POS_MOUSE);

	      	gtk_signal_connect (GTK_OBJECT (file_dialog), "destroy",
                          (GtkSignalFunc) fsel_abort,
                          &file_dialog);
	      	gtk_signal_connect (GTK_OBJECT (file_dialog), "delete_event",
                          (GtkSignalFunc) fsel_abort,
                          &file_dialog);

	      	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (file_dialog)->ok_button),
                          "clicked", (GtkSignalFunc) fsel_done,
                          file_dialog);
	      	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (file_dialog)->cancel_button),
                                 "clicked", (GtkSignalFunc) fsel_abort,
                                 GTK_OBJECT (file_dialog));
	}

	for (nchoices = 0; patterns[nchoices]; nchoices++);
	format = select_from_list("File format", patterns, nchoices);
	if (format < 0) return 0;
	strcpy(fmt, patterns[format]);
	status = WAITING;

	if (!GTK_WIDGET_VISIBLE (file_dialog))
    		gtk_widget_show (file_dialog);
  	else
    		gtk_widget_destroy (file_dialog);

	while (status == WAITING)
		gtk_main_iteration();
	gtk_widget_hide(file_dialog);

	strcpy(name, filename_buffer);
	path[0] = '\0';

	return status;
}

int alert_box(char *text, char *buttons[], int nbuttons)
{
        llpr(text);

	return 0;
}

static void listsel_done(GtkWidget *widget, GtkWidget **dummy)
{
	status = DONE;
}

static void listsel_abort(GtkWidget *widget, GtkWidget **dummy)
{
	status = ABORT;
}

static void listsel_destroy(GtkWidget *widget, GtkWidget **window)
{
	*window = NULL;
}

int select_from_list(char *text, char *choices[], int nchoices)
{
	GtkWidget *window;
	GtkWidget *box1, *box2, *scroll, *list, *list_item, *button,
		*separator;
	GList *dlist;
	int i, n = -1;
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(window), "destroy",
		(GtkSignalFunc)listsel_destroy, &window);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		(GtkSignalFunc)listsel_destroy, &window);
	gtk_window_set_title(GTK_WINDOW(window), text);

	box1 = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(window), box1);
	gtk_widget_show(box1);

	box2 = gtk_vbox_new(FALSE, 10);
	gtk_container_border_width(GTK_CONTAINER(box2), 10);
	gtk_box_pack_start(GTK_BOX(box1), box2, TRUE, TRUE, 0);
	gtk_widget_show(box2);

	scroll = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(box2), scroll, TRUE, TRUE, 0);
	gtk_widget_show(scroll);

	list = gtk_list_new();
	gtk_list_set_selection_mode(GTK_LIST(list), GTK_SELECTION_BROWSE);
	gtk_container_add(GTK_CONTAINER(scroll), list);
	gtk_widget_show(list);

	for (i = 0; i < nchoices; i++) {
		list_item = gtk_list_item_new_with_label(choices[i]);
		gtk_container_add(GTK_CONTAINER(list), list_item);
		gtk_widget_show(list_item);
	}

	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(box1), separator, FALSE, TRUE, 0);
	gtk_widget_show(separator);

	box2 = gtk_hbox_new(FALSE, 10);
	gtk_container_border_width(GTK_CONTAINER(box2), 10);
	gtk_box_pack_start(GTK_BOX(box1), box2, FALSE, TRUE, 0);
	gtk_widget_show(box2);

	button = gtk_button_new_with_label("OK");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		(GtkSignalFunc)listsel_done, NULL);
	gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);

	button = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		(GtkSignalFunc)listsel_abort, NULL);
	gtk_box_pack_start(GTK_BOX(box2), button, TRUE, TRUE, 0);
	gtk_widget_show(button);

	gtk_widget_show(window);
	status = WAITING;
	while (status == WAITING)
                gtk_main_iteration();
	dlist = GTK_LIST(list)->selection;
	if (!dlist) status = ABORT;
	else {
		list_item = GTK_WIDGET(dlist->data);
		n = gtk_list_child_position(GTK_LIST(list), list_item);
	}
	gtk_widget_destroy(window);
	if (status == ABORT) return -1;
	return n;
}

void error_box(char *message)
{
        llpr(message);
	return;
}

static LISP get_geometry(void)
{
	unsigned int width, height, border_width, depth;
	int x, y;
	LISP result;
	GtkWidget *grid = w_list->ui->grid;

	x = grid->allocation.x;
	y = grid->allocation.y;
	width = grid->allocation.width;
	height = grid->allocation.height;
	border_width = 1;	/* don't care */
	depth = 8;		/* or something */
	result = cons(flocons(depth), NIL);
        result = cons(flocons(border_width), result);
        result = cons(flocons(height), result);
        result = cons(flocons(width), result);
        result = cons(flocons(y), result);
        result = cons(flocons(x), result);

        return result;
}


static LISP set_block()
{
        if (get_point(w_list).row < get_mark(w_list).row) {
                set_blku_row(w_list, get_point(w_list).row);
                set_blkl_row(w_list, get_mark(w_list).row);
        } else {
                set_blku_row(w_list, get_mark(w_list).row);
                set_blkl_row(w_list, get_point(w_list).row);
        }
        if (get_point(w_list).col < get_mark(w_list).col) {
                set_blku_col(w_list, get_point(w_list).col);
                set_blkl_col(w_list, get_mark(w_list).col);
        } else {
                set_blku_col(w_list, get_mark(w_list).col);
                set_blkl_col(w_list, get_point(w_list).col);
        }

        pr_scr_flag = TRUE;
        return NIL;
}

static LISP unset_block()
{
        set_blku_row(w_list, -1); set_blku_col(w_list, -1);
        set_blkl_row(w_list, -1); set_blkl_col(w_list, -1);
        pr_scr_flag = TRUE;
        return NIL;
}

static LISP bogus()
{
TRACEME((f,"bogus()"));
	return NIL;
}

void interp_startup()
{
	init_subr_0("get-geometry", get_geometry);
        init_subr_0("set-block", set_block);
        init_subr_0("unset-block", unset_block);
   	init_subr_1("helptext-mode", bogus);
	return;
}

void embed_load()
{
        ;
}

int font_input(int *format, int *mask)
{
        return 0;       /* ABORT */
}

/* Dummy Postscript functions */
char *ps_fontname(int index)
{
        return "Helvetica";
}

int ps_text_width(int index, char *s)
{
        return 80;
}

int ps_font_descent(int index)
{
        return 5;
}

int ps_font_height(long font)
{
        return 10;
}

int ps_embed_print(FILE *fp, char *tag, int x_base, int y_base)
{
        return 0;
}

int ps_font_size(int index)
{
        return 10;
}

