\name{jpn}
\title{Plot Japan's Coast Line and Prefectures}
\usage{
jpn(region, xlim = c(128, 147), ylim = c(29.6, 47), pref = T, 
    coast = T, add = F, okinawa = T, ar = 4/5, eps = 0.25, ...)
}
\arguments{
\item{region}{region which should be drawn.  A list containing
components named \code{x} and \code{y} or a list of such objects.  If
missing, \code{xlim} and \code{ylim} are used.}
\item{xlim}{optional limits for the x-axis (longitude).  The longitude
for Okinawa is different from the real one.  See argument \code{okinawa}.}
\item{ylim}{optional limits for the y-axis (latitude).  The latitude for
Okinawa is different from the real one.  See argument \code{okinawa}.}
\item{pref}{logical flag to control whether prefecture boundaries are
plotted or not.}
\item{coast}{logical flag to control whether coast-line is plotted or
not.}
\item{add}{logical flag. If TRUE, plot is superimposed on existing plot.
Otherwise, a new plot is generated.}
\item{okinawa}{logical flag.  Okinawa is drawn in the box placed on the
Japan sea.  To put points or draw texts around Okinawa, shift longitude
by +3.7767(degrees) and latitude by +13.05505(degrees).}
\item{ar}{aspect ratio of \code{longitude} to \code{latitude}.}
\item{eps}{If \code{region} is given, it is enlarged four ways by this
amout(degrees).}
\item{...}{optional arguments which will be passed through \code{lines}.}
Graphical parameters (see \code{par()}) may also be supplied as arguments
to this function.
}
\examples{
## Region which includes Aomori and Osaka
jpn(list(jcity$aomori, jcity$osaka), eps = 0.7)
## Around Fukuoka
jpn(jcity$fukuoka, eps = 1)
## Shikoku Island
jpn(xlim = c(132, 135), ylim = c(32.5, 34.5))
}
