#include "netcdf.h"
#include "ncfortran.h"


/*
 * Create a netCDF dataset.
 */
FCALLSCFUN3(INT, nc_create, NF_CREATE, nf_create,
	    STRING, INT, PNCID)


/*
 * Open a netCDF dataset.
 */
FCALLSCFUN3(INT, nc_open, NF_OPEN, nf_open,
	    STRING, INT, PNCID)


/*
 * Set the fill mode of a netCDF dataset.
 */
FCALLSCFUN3(INT, nc_set_fill, NF_SET_FILL, nf_set_fill,
	    NCID, INT, PINT)


/*
 * Put a netCDF dataset into redefine mode.
 */
FCALLSCFUN1(INT, nc_redef, NF_REDEF, nf_redef,
	    NCID)


/*
 * End definition mode for a netCDF dataset.
 */
FCALLSCFUN1(INT, nc_enddef, NF_ENDDEF, nf_enddef,
	    NCID)


/*
 * Synchronize the external representation of a netCDF dataset with its
 * internal one.
 */
FCALLSCFUN1(INT, nc_sync, NF_SYNC, nf_sync,
	    NCID)


/*
 * Abort changes to a netCDF dataset.
 */
FCALLSCFUN1(INT, nc_abort, NF_ABORT, nf_abort,
	    NCID)


/*
 * Close a netCDF dataset.
 */
FCALLSCFUN1(INT, nc_close, NF_CLOSE, nf_close,
	    NCID)


/*
 * Delete a netCDF dataset.
 */
EXTERNL int nc_delete(const char * path); /* defined in ../libsrc/nc.c */
FCALLSCFUN1(INT, nc_delete, NF_DELETE, nf_delete,
	    STRING)
