/*								-*- C++ -*-
 * $Id: UTL_utilities.h,v 1.5 1997-01-30 09:55:27+01 mho Exp $
 *
 * Purpose: common utilities
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef wxUtilities_h
#define wxUtilities_h

#ifdef __GNUG__
#pragma interface
#endif

class wxCursor;
class wxFrame;
class wxObject;
class wxPanel;
class wxWindow;

// propable conficts
// #undef  min
// #define min(a,b) ((a)<(b)?(a):(b))
// #undef  max
// #define max(a,b) ((a)>(b)?(a):(b))
// #undef  abs
// #define abs(a) ((a)>=0?(a):(-(a)))

#define wxMin(a,b) ((a)<(b)?(a):(b))
#define wxMax(a,b) ((a)>(b)?(a):(b))
#define wxAbs(a) ((a)>=0?(a):(-(a)))
#undef  wxNumberOf
#define wxNumberOf(arr) ((int)(sizeof(arr)/sizeof(arr[0])))

// application utilities
void wxExit(void);
void wxFlushEvents(void);
Bool wxYield(void);
// delete object after event finished
void wxPostDelete(wxObject *object);
void wxPostDeletion(void);

#if USE_TYPETREE
// old type checking
Bool wxSubType(WXTYPE type1, WXTYPE type2);
char *wxGetTypeName(WXTYPE type);
#endif

// File functions
Bool wxConcatFiles(const char *src1, const char *src2, const char *dest);
char *wxContractPath(const char *fname, const char *envname, const char *user);
char *wxCopyAbsolutePath(const char *path);
Bool wxCopyFile(const char *src, const char *dest);
Bool wxDirExists(const char *dirname);
void wxDos2UnixFilename(char *s);
char *wxExpandPath(char *buf, const char *name);
Bool wxFileExists(const char *filename);
char *wxFileNameFromPath(const char *path);
char *wxFindFirstFile(const char *spec, int flags=0);
char *wxFindNextFile(void);
char *wxGetHomeDir(char *buf);
char *wxGetUserHome(const char *user);
char *wxGetWorkingDirectory(char *buf=NULL, int sz=0);
char *wxGetTempFileName(char *prefix, char *buff=NULL);
Bool wxIsAbsolutePath(char *filename);
Bool wxIsWild(char *pattern);
Bool wxMatchWild(char *pattern, char *text, Bool dot_special=FALSE);
Bool wxMkdir(const char *dir);
char *wxPathOnly(char *path);
char *wxRealPath (char *path);
Bool wxRemoveFile(const char *file);
Bool wxRenameFile(const char *old, const char *_new);
Bool wxRmdir(const char *dir);
Bool wxSetWorkingDirectory(char *dir);
void wxStripExtension(char *buffer);
void wxUnix2DosFilename(char *s);

#define DirExists wxDirExists
#define Dos2UnixFilename wxDos2UnixFilename
#define FileExists wxFileExists
#define FileNameFromPath wxFileNameFromPath
#define IsAbsolutePath wxIsAbsolutePath
#define PathOnly wxPathOnly
#define Unix2DosFilename wxUnix2DosFilename

// Network functions
Bool wxGetHostName(char *buf, int sz);
Bool wxGetEmailAddress(char *buf, int sz);
Bool wxGetUserId(char *buf, int sz);
Bool wxGetUserName(char *buf, int sz);

// String functions
char *copystring(const char *s);
int  str16len(const char *s);
void wxStringToDouble(char *s, double *number);
void wxStringToFloat(char *s, float *number);
void wxStringToInt(char *s, int *number);
void wxStringToLong(char *s, long *number);
char *wxDoubleToString(double number);
char *wxFloatToString(float number);
char *wxIntToString(int number);
char *wxLongToString(long number);
Bool wxStringMatch(char *one, char *two, Bool subString = TRUE,
		   Bool exact = FALSE);
int  wxStringEq(char *s1, char *s2);
char *wxStripMenuCodes(char *in, char *out);

// dec <-> 2-character hex
int  wxHexToDec(char *buf);
void wxDecToHex(int dec, char *buf);

#define StringToDouble wxStringToDouble
#define StringToFloat wxStringToFloat
#define StringToInt wxStringToInt
#define StringToLong wxStringToLong
#define DoubleToString wxDoubleToString
#define FloatToString wxFloatToString
#define IntToString wxIntToString
#define LongToString wxLongToString
#define StringMatch wxStringMatch

#define wxToUpper(C) (((C) >= 'a' && (C) <= 'z')? (C) - 'a' + 'A': (C))
#define wxToLower(C) (((C) >= 'A' && (C) <= 'Z')? (C) - 'A' + 'a': (C))

// GC changing

#ifdef Have_X_Types
void wxMakeCopyGC(Display *dpy, GC gc, unsigned long background);
void wxMakeXorGC(Display *dpy, GC gc, unsigned long background);
void wxMakeNoClipGC(Display *dpy, GC gc);
void wxMakeClipGC(Display *dpy, GC gc);
#endif

// GDI functions
Bool wxColourDisplay(void);
int  wxDisplayDepth(void);
void wxDisplaySize(int *width, int *height);
void wxSetCursor(wxCursor *cursor);

// Printer settings

// Clipboard functions

// busy cursor
void wxBeginBusyCursor(wxCursor *cursor = wxHOURGLASS_CURSOR);
void wxEndBusyCursor(void);
Bool wxIsBusy(void);

// print window hierarchy below window
void wxPrintChildren(wxWindow *window, int level=0);

// find wxWindows objects
int wxFindMenuItemId(wxFrame *frame, char *menuString, char *itemString);
wxWindow *wxFindWindowByLabel(char *title, wxWindow *parent=NULL);
wxWindow *wxFindWindowByName(char *title, wxWindow *parent=NULL);
wxWindow *wxGetActiveWindow(void);

// Miscellaneous
void wxBell(void);
long wxGetCurrentId(void);
long NewId(void);
void RegisterId(long id);
Bool wxExecute(char **argv, Bool Async = FALSE);
Bool wxExecute(const char *command, Bool Async = FALSE);
long wxGetFreeMemory(void);
int wxGetOsVersion(int *majorVsn, int *minorVsn);
Bool wxShell(const char *command = NULL);
void wxSleep(int nSecs);
char *wxNow(void);
void wxStartTimer(void);
long wxGetElapsedTime(Bool resetTimer = TRUE);
Bool wxGetLocalTime(long *timeZone, int *dstObserved);
long wxGetCurrentTime(void);
Bool wxIsFrame(wxWindow *win);
Bool wxIsItem(wxWindow *win);
Bool wxIsPanel(wxWindow *win);
wxWindow* wxFindFrame(wxWindow *win);
wxWindow* wxFindPanel(wxWindow *win);

// error/debugging
void wxDebugMsg(const char *fmt, ...);
void wxError(const char *msg, const char *title=wxInternalErrorStr);
void wxFatalError(const char *msg, const char *title=wxFatalErrorStr);

// read/write resources
#if USE_RESOURCES
Bool wxGetResource(const char *section, const char *entry, char **value,
		   const char *file = NULL);
Bool wxGetResource(const char *section, const char *entry, float *value,
		   const char *file = NULL);
Bool wxGetResource(const char *section, const char *entry, long *value,
		   const char *file = NULL);
Bool wxGetResource(const char *section, const char *entry, int *value,
		   const char *file = NULL);
Bool wxWriteResource(const char *section, const char *entry, char *value,
		     const char *file = NULL);
Bool wxWriteResource(const char *section, const char *entry, float value,
		     const char *file = NULL);
Bool wxWriteResource(const char *section, const char *entry, long value,
		     const char *file = NULL);
Bool wxWriteResource(const char *section, const char *entry, int value,
		     const char *file = NULL);
void wxDeleteResources(const char *file);
#endif // USE_RESOURCES

#endif // wxUtilities_h
