/*								-*- C++ -*-
 * $Id: DLG_text.cpp,v 1.2 1997-01-30 09:55:56+01 mho Exp $
 *
 * Purpose: get single text input
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#define  Uses_wxDialogBase
#define  Uses_wxText
#include "wx.h"

#include <string.h>

char *wxGetTextFromUser(const char *message, const char *caption,
			const char *default_value,
			wxWindow *parent, int x, int y, Bool centre)
{
    // create dialog box and text item
    wxDialogBase *box
	= wxNEW wxDialogBase(message, NULL, caption,
			     (centre ? wxCENTRE : 0) | wxOK | wxCANCEL,
			     parent, x, y);
    wxText *txt
	= wxNEW wxText(box, (wxFunction)NULL, NULL, default_value);
    // wait for input
    char *ret_value = NULL;
    if (box->GetInput() == wxOK && txt->GetValue()) {
	strncpy(wxBuffer, txt->GetValue(), wxBufferSize);
	ret_value = wxBuffer;
    }
    delete box;
    return ret_value;
}
