#undef DO_MAIN
/* rws 7 Apr 1997
	It is best to start this with -geometry +500+500 (or whatever)
	otherwise the time to place it by the window manager bungs up the
	first test

	Is there a event, or callback one can use to figure out when the
	window has been placed????
*/
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>

#ifdef DO_MAIN
typedef struct {
	int time;
       } AppResources_t, *AppResourcesPtr;
AppResources_t AppResources;

static String FallBack[] = {
	"*borderWidth: 1",
	"*geometry: +500+500",
NULL};

static XtResource resources[] = {
	/*
	{"time","time",XtRInt,sizeof(int),XtOffset(AppResourcesPtr,time),XtRImmediate, (void *)1000},
	*/
};

static XrmOptionDescRec opTable[] = {
	{"-time",".time",XrmoptionSepArg, NULL},
};


XtAppContext app;
#endif

typedef struct {
	Widget W;
	XtWidgetGeometry *Expected;
} Request;

static Boolean GlobalResult = True;

static void
PrintWidgetDetails(Widget W, XtWidgetGeometry *ExpectedResults)
{
static int result_index = 0;
XtWidgetGeometry geo;
Boolean Result;
int i;
WidgetList kids;
Cardinal numkids = 0;
XtGeometryMask mode;
XtWidgetGeometry *Expected;

	if (ExpectedResults == NULL)
		Expected = &geo;
	else
		Expected = &ExpectedResults[result_index];
	mode = Expected->request_mode;
	XtVaGetValues(W,
		XmNchildren, &kids,
		XmNnumChildren, &numkids,
		XmNwidth, &geo.width,
		XmNheight, &geo.height,
		XmNx, &geo.x,
		XmNy, &geo.y,
		NULL);
	if (XtIsManaged(W))
	{
		Result = (mode & CWX ? Expected->x == geo.x : True) &&
			 (mode & CWY ? Expected->y == geo.y : True) &&
			 (mode & CWWidth ? Expected->width == geo.width : True) &&
			 (mode & CWHeight ? Expected->height == geo.height : True);

		GlobalResult = GlobalResult && Result;

		printf("%15s x %-4i(%4i) y %-4i(%4i) w %-4i(%4i) h %-4i(%4i) %s\n",XtName(W),
			geo.x, (Expected->request_mode & CWX ? Expected->x : geo.x),
			geo.y, (Expected->request_mode & CWY ? Expected->y : geo.y),
			geo.width, (Expected->request_mode & CWWidth ? Expected->width : geo.width),
			geo.height, (Expected->request_mode & CWHeight ? Expected->height : geo.height),
			Result ? "Good" : "Bad");

		result_index++;
	}
	for (i=0; i<numkids; i++)
	{
		PrintWidgetDetails(kids[i], ExpectedResults);
	}

}

static Boolean
_PrintDetails(Request *request)
{
int i;
WidgetList kids;
Cardinal numkids;

	XmUpdateDisplay(request->W);
	PrintWidgetDetails(request->W, request->Expected);
	/*
	XtVaGetValues(request->W,
		XmNchildren, &kids,
		XmNnumChildren, &numkids,
		NULL);
	for (i=0; i<numkids; i++)
	{
		PrintWidgetDetails(kids[i], request->Expected);
	}
	*/
	printf("%s\n",GlobalResult ? "All good" : "One or more failed");
	return(True);
}

Boolean
PrintDetails(Widget W, XtWidgetGeometry *Expected)
{
static Request request;

	request.W = W;
	request.Expected = Expected;
	XtAppAddTimeOut(XtWidgetToApplicationContext(W), 0, (void *)_PrintDetails, &request);
}

#ifdef DO_MAIN
int
main(int argc, char **argv)
{
  Widget toplevel, Form, BottomLabel, TopLabel;

  XtSetLanguageProc(NULL, NULL, NULL);

  toplevel = XtVaAppInitialize(&app,
  	"Form1", 
  	opTable, XtNumber(opTable),
  	&argc, argv,
  	FallBack, NULL);

  XtGetApplicationResources(toplevel,
  		&AppResources,
  		resources, XtNumber(resources),
  		NULL,0);

  XtVaSetValues(toplevel,
  	XmNresizePolicy, XmRESIZE_ANY,
  	XmNallowShellResize, True,
  	NULL);

  Form = XmCreateForm(toplevel,"Form",NULL,0);
  XtVaSetValues(Form,
  	XmNresizePolicy, XmRESIZE_ANY,
  	XmNallowShellResize, True,
  	NULL);

  TopLabel = XmCreateLabel(Form, "TopLabelTop", NULL, 0);
  BottomLabel = XmCreateLabel(Form, "BottomLabel", NULL, 0);

  XtVaSetValues(TopLabel,
  	XmNtopAttachment, XmATTACH_FORM,
  	XmNbottomAttachment, XmATTACH_WIDGET,
  	XmNbottomWidget, BottomLabel,
  	XmNleftAttachment, XmATTACH_FORM,
  	XmNrightAttachment, XmATTACH_FORM,
  	NULL);
  XtManageChild(TopLabel);

  XtVaSetValues(BottomLabel,
  	XmNtopAttachment, XmATTACH_NONE,
  	XmNbottomAttachment, XmATTACH_FORM,
  	XmNleftAttachment, XmATTACH_FORM,
  	XmNrightAttachment, XmATTACH_FORM,
  	NULL);
  XtManageChild(BottomLabel);

  XtManageChild(Form);

  XtRealizeWidget(toplevel);

  PrintDetails(toplevel);

  XtAppMainLoop(app);

  exit(0);
}
#endif
