""" Demonstration of the Pmw ScrolledText megawidget.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import os
import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	# Create and pack the ScrolledText.
	st = Pmw.ScrolledText(parent,
		hscrollmode = 'static',
		vscrollmode = 'static',
		labelpos = 'n',
		label_text='ScrolledText.py',
		text_background = 'aliceblue',
		text_width = 40,
		text_height = 15,
		text_padx = 10,
		text_pady = 10,
		text_wrap='none',
		text_relief='groove')
	st.pack(padx=10, pady=10, fill='both', expand='yes')
	head, tail = os.path.split(sys.argv[0])
	st.importfile(os.path.join(head,'ScrolledText.py'))
	st.configure(text_state = 'disabled')
	st.yview(0)

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Pmw ScrolledText demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
