// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLFileInfo.C

  Stephane Rehel

  September 28 1997
*/

#include "MLFileInfo.h"

#include "MLRFileBlock.h"
#include "MLWFileBlock.h"

#include "tools/Chrono.h"
#include "tools/ListFiles.h"

/////////////////////////////////////////////////////////////////////////////

static const int info_version= 1;

/////////////////////////////////////////////////////////////////////////////

MLFileInfo::MLFileInfo()
{
  version= "";
  user= "";
  sysname= "";
  machine= "";
  timeofday= 0;
}

/////////////////////////////////////////////////////////////////////////////

MLFileInfo::~MLFileInfo()
{}

/////////////////////////////////////////////////////////////////////////////

// static
void MLFileInfo::write( const OString& version,
                        const OString& sysname,
                        const OString& machine,
                        MLWFileBlock& block )
{
  OString user= ListFiles::getUserName();
  unsigned long timeofday= Chrono::gettimeofday();

  block << int(::info_version);
  writeString( version, block );
  writeString( user, block );
  writeString( sysname, block );
  writeString( machine, block );

  block << timeofday;
}

/////////////////////////////////////////////////////////////////////////////

void MLFileInfo::read( MLRFileBlock& block )
{
  block.getInteger(); // info_version

  version= readString(block);
  user= readString(block);
  sysname= readString(block);
  machine= readString(block);
  block >> timeofday;
}

/////////////////////////////////////////////////////////////////////////////

OString MLFileInfo::getTimeOfDay() const
{
  return ListFiles::getDateString( (time_t) timeofday );
}

/////////////////////////////////////////////////////////////////////////////

// static
void MLFileInfo::writeString( const OString& s, MLWFileBlock& block )
{
  block << int(s.length());

  unsigned int u= s.length();
  for( int i= 0; i < s.length(); ++i )
    {
    unsigned int ch= (unsigned int) (unsigned char) s[i];
    ch += u;
    block << ch;
    u+= u * u * (unsigned int)(i+1);
    }
}

/////////////////////////////////////////////////////////////////////////////

// static
OString MLFileInfo::readString( MLRFileBlock& block )
{
  OString s("");

  int length;
  block >> length;
  if( length <= 0 || length > 1024 )
    return s;

  s.fill( length, ' ' );
  unsigned int u= length;
  for( int i= 0; i < length; ++i )
    {
    unsigned int ch;
    block >> ch;
    ch -= u;
    s.put( i, (unsigned char) ch );
    u+= u * u * (unsigned int)(i+1);
    }

  return s;
}

/////////////////////////////////////////////////////////////////////////////
