// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  OFFLoader.h

  Stephane Rehel
  April 29 1997
*/

#ifndef __OFFLoader_h
#define __OFFLoader_h

#include <stdio.h>

#ifndef __Vector_h
#include "tools/Vector.h"
#endif

#ifndef __OString_h
#include "tools/OString.h"
#endif

#ifndef __Array1_h
#include "tools/Array1.h"
#endif

class MLImporter;
class MLScene;

/////////////////////////////////////////////////////////////////////////////

class OFFLoader
{
private:
  MLImporter* importer;
  MLScene* scene;

  FILE* file;
  OString filename;
  int lineN;
  char line[1024];

public:
  OFFLoader( MLImporter* _importer );

  virtual ~OFFLoader();

  IBOOL init();
  IBOOL load();

private:
  char* getline();
  int getint( char*& l, int& i );
  void fatal_error();
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __OFFLoader_h
