// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  Photo.C

  Stephane Rehel

  October 25 1997
*/

#include "Photo.h"

#include "image/MLImage.h"
#include "image/MLImageReader.h"

/////////////////////////////////////////////////////////////////////////////

Photo::Photo()
{
  image= 0;
}

/////////////////////////////////////////////////////////////////////////////

Photo::~Photo()
{
  delete image;
  image= 0;
}

/////////////////////////////////////////////////////////////////////////////

IBOOL Photo::load( const OString& filename )
{
  MLImageReader* reader= MLImageReader::guessReader(filename);
  if( reader == 0 )
    return IFALSE;

  if( ! reader->open(filename) )
    {
    delete reader;
    reader= 0;

    return IFALSE;
    }

  delete image;
  image= new MLImage;

  if( ! reader->read(image) )
    {
    delete image;
    image= 0;
    delete reader;
    reader= 0;

    return IFALSE;
    }

  delete reader;
  reader= 0;

  image->upsidedown();

  return ITRUE;
}

/////////////////////////////////////////////////////////////////////////////
