// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  handlePhotoCommand.C

  void PhotoModule::handlePhotoCommand( PhotoCommand* cmd );

  Stephane Rehel

  October 25 1997
*/

#include <stdio.h>

#include "interface/MLPopup.h"

#include "PhotoPopups.h"

#include "PhotoCommand.h"
#include "PhotoCommands.h"
#include "PhotoStatusBars.h"
#include "PhotoModule.h"

#include "photo/Photo.h"

/////////////////////////////////////////////////////////////////////////////

void PhotoModule::handlePhotoCommand( PhotoCommand* cmd )
{
  if( cmd == 0 )
    return;

  if( cmd->doit(this) )
    return; // implemented into the command

  switch( cmd->getType() )
    {
    case PhotoCommands::SELECT:
      {
      /* ... */

//      refreshScreen( REFRESH_COLOR );
      return;
      }

    case PhotoCommands::LOAD_IMAGE:
      {
      OString filename= cmd->string;

      pushWaitCursor();
      if( ! getPhoto()->load(filename) )
        printMessage("Error loading " + filename);
      popWaitCursor();

      refreshScreen(REFRESH_PHOTO);
      return;
      }

    default:
      break;
    }
}

/////////////////////////////////////////////////////////////////////////////
