// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLFunction.C

  Stephane Rehel
  August 2 1997
*/

#include "MLFunction.h"

#include "MLFunctionsManager.h"
#include "MLModule.h"

/////////////////////////////////////////////////////////////////////////////

MLFunction::MLFunction( MLModule* _module )
{
  module= _module;

  function_id= 0;

  please_return= IFALSE;
  cancelled= IFALSE;
  exitFunction= IFALSE;
}

/////////////////////////////////////////////////////////////////////////////

MLFunction::~MLFunction()
{
  module= 0;
}

/////////////////////////////////////////////////////////////////////////////

// return IFALSE if cancelled
IBOOL MLFunction::call()
{
  return module->getFunctionsManager()->call(this);
}

/////////////////////////////////////////////////////////////////////////////

IBOOL MLFunction::isBaseFunction() const
{
  return IFALSE;
}

/////////////////////////////////////////////////////////////////////////////

// set function validated
// return ITRUE if successully completed
IBOOL MLFunction::validate()
{
  please_return= ITRUE;
  cancelled= IFALSE;
  exitFunction= IFALSE;

  return ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

// set function completed
// return ITRUE if successully completed
IBOOL MLFunction::complete()
{
  please_return= ITRUE;
  cancelled= IFALSE;
  exitFunction= ITRUE;

  return ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

// set function cancelled
// return ITRUE if successully cancelled
IBOOL MLFunction::cancel()
{
  please_return= ITRUE;
  cancelled= ITRUE;
  exitFunction= ITRUE;

  return ITRUE;
}

/////////////////////////////////////////////////////////////////////////////
