// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLImageReaderTIF.h

  Stephane Rehel

  August 20 1997
*/

#ifndef __MLImageReaderTIF_h
#define __MLImageReaderTIF_h

#ifndef __MLImageReader_h
#include "image/MLImageReader.h"
#endif

/////////////////////////////////////////////////////////////////////////////

class MLImageReaderTIF: public MLImageReader
{
protected:
  void* _tiff;

public:
  MLImageReaderTIF();

  virtual ~MLImageReaderTIF();

  virtual IBOOL available() const;

  MLImageFormat::FORMAT getFormat() const;

  virtual void close();
  virtual IBOOL open( const OString& filename );

  virtual IBOOL read( MLImage* image );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLImageReaderTIF_h
