.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutBitmapCharacter 3GLUT "3.6" "GLUT" "GLUT"
.SH NAME
glutBitmapCharacter - renders a bitmap character using OpenGL. 
.SH SYNTAX
.nf
.LP
void glutBitmapCharacter(void *font, int character);
.fi
.SH ARGUMENTS
.IP \fIfont\fP 1i
Bitmap font to use. 
.IP \fIcharacter\fP 1i
Character to render (not confined to 8 bits). 
.SH DESCRIPTION
Without using any display lists, glutBitmapCharacter renders the
character in the named bitmap font. The available fonts are: 
.TP 8
.B GLUT_BITMAP_8_BY_13 
A fixed width font with every character fitting in an 8 by 13 pixel
rectangle. The exact bitmaps to be used is defined by the standard X
glyph bitmaps for the X font named: 

-misc-fixed-medium-r-normal--13-120-75-75-C-80-iso8859-1

.TP 8
.B GLUT_BITMAP_9_BY_15 
A fixed width font with every character fitting in an 9 by 15 pixel
rectangle. The exact bitmaps to be used is defined by the standard X
glyph bitmaps for the X font named: 

-misc-fixed-medium-r-normal--15-140-75-75-C-90-iso8859-1

.TP 8
.B GLUT_BITMAP_TIMES_ROMAN_10 
A 10-point proportional spaced Times Roman font. The exact
bitmaps to be used is defined by the standard X glyph bitmaps for
the X font named: 

-adobe-times-medium-r-normal--10-100-75-75-p-54-iso8859-1

.TP 8
.B GLUT_BITMAP_TIMES_ROMAN_24 
A 24-point proportional spaced Times Roman font. The exact
bitmaps to be used is defined by the standard X glyph bitmaps for
the X font named: 

-adobe-times-medium-r-normal--24-240-75-75-p-124-iso8859-1

.TP 8
.B GLUT_BITMAP_HELVETICA_10 
A 10-point proportional spaced Helvetica font. The exact bitmaps
to be used is defined by the standard X glyph bitmaps for the X font
named: 

-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1

.TP 8
.B GLUT_BITMAP_HELVETICA_12 
A 12-point proportional spaced Helvetica font. The exact bitmaps
to be used is defined by the standard X glyph bitmaps for the X font
named: 

-adobe-helvetica-medium-r-normal--12-120-75-75-p-67-iso8859-1

.TP 8
.B GLUT_BITMAP_HELVETICA_18 
A 18-point proportional spaced Helvetica font. The exact bitmaps
to be used is defined by the standard X glyph bitmaps for the X font
named: 

-adobe-helvetica-medium-r-normal--18-180-75-75-p-98-iso8859-1
.LP
Rendering a nonexistent character has no effect.
glutBitmapCharacter automatically sets the OpenGL unpack pixel
storage modes it needs appropriately and saves and restores the previous
modes before returning. The generated call to glBitmap will adjust the
current raster position based on the width of the character. 
.SH EXAMPLE
Here is a routine that shows how to render a string of ASCII
text with glutBitmapCharacter:
.nf
.LP
  void
  output(int x, int y, char *string)
  {
    int len, i;

    glRasterPos2f(x, y);
    len = (int) strlen(string);
    for (i = 0; i < len; i++) {
      glutBitmapCharacter(GLUT_BITMAP_HELVETICA_18, string[i]);
    }
  }
.fi
.LP
.SH SEE ALSO
glutBitmapWidth, glutStrokeCharacter
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
