######################################################################
### This function unset all variables which are associated with a page
######################################################################
proc unsetPage {page} {
  global __widgetArgs __children

  foreach child $__children(${page}__top) {
    unsetElm $page $child __$page
  }
}

######################################################################
### This function unset all variables from name and below,
### on the page called 'function' with prefix 'prefix'
######################################################################
proc unsetElm {function name prefix} {
  global __widgetArgs __children __scrollBar __fillList __state

  set type $__widgetArgs(${function}__${name}__type)
  switch $type {
    checkbox -
    entry -
    int -
    float -
    label  -
    command  -
    textbox -
    radio -
    combobox -
    menu -
    listbox {
      uplevel \#0 unset ${prefix}_$name
      catch "unset __state(${prefix}_$name)"
    }
    window -
    frame {
      foreach child $__children(${function}__${name}) {
        unsetElm $function $child $prefix
      }
    }
    extentry {
      set count [lindex $__scrollBar(${prefix}_${name}) 1]
      unset __scrollBar(${prefix}_${name})
      for {set i 0} {$i < $count} {incr i} {
        foreach child $__children(${function}__${name}) {
          unsetElm $function $child ${prefix}_${name}$i
        }
      }
      catch "unset __state(${prefix}_$name)"
    }
    fillout {
      foreach elm $__fillList(${prefix}_$name) {
        set elmName [lindex $elm 2]
        set counter [lindex $elm 3]

        if {$counter != -1} {
          foreach child $__children(${function}__$elmName) {
            unsetElm $function $child ${prefix}_${name}_$counter
          }
        }
      }
      unset __fillList(${prefix}_$name)
      uplevel \#0 unset ${prefix}_$name
      catch "unset __state(${prefix}_$name)"
    }
  }
}

######################################################################
### This function sets the basic elements on a page, ie.
### all elements which are not part of any ExtEntries will be set.
### ExtEntries will be set to contain 0 elements.
######################################################################
proc setBasic {page} {
  global __children __scrolValue __widgetArgs

  foreach child $__children(${page}__top) {
    setVariable $page $child __$page \
        $__widgetArgs(${page}__${child}__default) 0
  }
}

######################################################################
### This function initialize unset extentries on page 'page'
### This is necesary, so all visual elements and extentries with
### fixed size are initialized.
######################################################################
proc setDefaultsOnPage {page} {
  global __children __widgetArgs
  foreach child $__children(${page}__top) {
    setDefaultsFromElm $page $child __$page $__widgetArgs(${page}__${child}__default)
  }
}

######################################################################
### This initialize all unset extentries from 'name' and below
### on page 'function'.
######################################################################
proc setDefaultsFromElm {function name prefix default} {
  global __children __widgetArgs __fillList __scrollBar
  global __editInfo

  if {$default == ""} {
    set default $__widgetArgs(${function}__${name}__default)
  }
  set type $__widgetArgs(${function}__${name}__type)
  set __editInfo(name) $function

  switch $type {
    checkbox -
    entry -
    int -
    float -
    label  -
    command  -
    textbox -
    radio -
    combobox -
    menu -
    listbox -
    fillout {}

    window -
    frame -
    filloutelm {
      foreach child $__children(${function}__$name) {
        setDefaultsFromElm $function $child $prefix $default
      }
    }
    extentry {
      set numberInitialized [lindex $__scrollBar(${prefix}_${name}) 1]
      set count $__widgetArgs(${function}__${name}__count)
      set maxentries $__widgetArgs(${function}__${name}__maxentries)
      set max $numberInitialized
      set length [llength $default]
      if {$length > $max} {
        set max $length
      }
      if {$maxentries != "Inf"} {
        set max $maxentries
      }

      ### running through all the elements
      for {set i 0} {$i < $max} {incr i} {
        set childIndex 0
        foreach child $__children(${function}__$name) {
          set type $__widgetArgs(${function}__${child}__type)
          if {$type == "line" || $type == "header"} continue
          set j [noOfVariableChildren $function $child]
          if {$length <= $i} {
            set val $__widgetArgs(${function}__${child}__default) 
          } else {
            set val [lindex $default $i] 
          }
          if {$childIndex != [expr $childIndex+$j-1]} {
            set value [lrange $val  $childIndex [expr $childIndex+$j-1]]
          } else {
            set value [lindex $val $childIndex]
          }
          
      
          incr childIndex
          if {$i < $numberInitialized} {
            setDefaultsFromElm $function $child ${prefix}_$name$i $value
          } else {
            setVariable $function $child ${prefix}_$name$i $value 1
          }
        }
      }

      ### setting the scrollbar
      set __scrollBar(${prefix}_${name}) "0 $max"
    }
  }
}

