#! /bin/sh
# create a root1440.bin floppy image for 2 floppies boot
# (sparc temporarily needs it while waiting for a fix to ld in generating
#  the small libc6 from the PIC library).
# (C) Eric Delaunay, 1998.
# This is free software under the GNU General Public License.

# Abort on any non-zero return.
set -e

# Verbose shell execution.
#set -x
#set -v

arch="`dpkg --print-architecture`"

# Print a usage message and exit if the argument count is wrong.
if [ $# != 4 ]; then
echo "Usage: "$0" revision-extension root-image blocks debian-version" 1>&2
	cat 1>&2 << EOF

	revision-extension: the revision extension of the kernel.
	root-image: a compressed disk image to load in ramdisk and mount as root.
	blocks: the size of the floppy in 1K blocks, use 720, 1200, or 1440.
	debian-version: version of the Debian release.
EOF

	exit -1
fi

revext=$1

# Set this to the location of the root filesystem image
rootimage=$2

# Set to the number of blocks per floppy.
blocks=$3

#Set this to the Debian version
debianversion=$4

# create the root floppy, in case there is not enough space on one disk
# to hold both kernel + root.bin.

cp $rootimage root${blocks}${revext}.bin
size=`wc -c < root${blocks}${revext}.bin`
size=`expr 1440 \* 1024 - $size`
blk=`expr $size / 1024`
rem=`expr $size % 1024`
dd if=/dev/zero bs=1 count=$rem >> root${blocks}${revext}.bin
dd if=/dev/zero bs=1k count=$blk >> root${blocks}${revext}.bin
ls -l root${blocks}${revext}.bin

