.TH XISP 1 "X11 Utilities" "Linux"
.SH NAME
xisp \- an X11 visual interface to pppd/chat
.SH SYNOPSIS
.TP 6
.B xisp\ \ [-bgcol\ #<6-digit\ hex\ color>] [-iconic] \
[-geometry\ [=][<W>{xX}<H>][{+-}<XO>{+-}<YO>]] \
[XForms parameters]
.SH "DESCRIPTION"
.BR xisp 
implements a user-friendly interface to pppd/chat
and provides maximum feedback from the dial-in and login phases on a
browser screen, as well as a manual login terminal window. It also
provides greater versatility in interrupting a call in progress and in
general enhances the user's feeling of "what's going on", especially
if she/he is not all that well acquainted with the intricacies of
system log files. It's also much nicer to look at as compared to
connection scripts writing output on the terminal :) The main
application, xisp, relies on a special dialer, xispdial, which is
spawned by pppd in order to perform the dialing, and a "bare bones"
terminal interface, xispterm.
.PP
The other facility provided by xisp
is that of maintaining a small data base of Internet Service Providers
(ISP's). It currently supports 8 such ISP entries. Each entry, aside
from user account name and password, has space for 8 telephone numbers,
two dialing parameters determining number of redials and inter-dialing
delay, eight user customizable script lines for the chat program, and
a wealth of pppd options to cover most communication needs. All data
base information is saved in the xisp resource control file \fI.xisprc\fP
in the user's home directory.
.PP
For a brief presentation on the operation of xisp and in particular
on the parameters available from within its "Options" menu, invoke
item "General" from within the "Help" menu. For a general discussion
on the workings of xisp, its dialer xispdial and its helper terminal
program xispterm, as well as their interaction with pppd and chat,
see the "ARCHITECTURE" section in file README of the xisp distribution.
.SH OPTIONS
xisp accepts all of the standard XForms command line options along
with the additional options listed below:
.TP 8
.B \-bgcol #<6-digit hex color>
Enables changing the default background color for all program
windows, and also the background color used by xispdial. The desired color
is entered as a six-digit hexadecimal number, 2 digits for each one of the
three basic colors, red green and blue.
.PP
.TP 8
.B \-iconic
.br
Instructs the window manager to start up xisp iconized.
.PP
.TP 8
.B \-geometry [=][<W>{xX}<H>][{+-}<XO>{+-}<YO>]
Instructs the window manager to adjust the size of the xisp window
and to place it at the location specified. W denotes width, H height,
XO x-offset and YO y-offset. The syntax for this geometry string is
the standard one used by all X11 applications.
.PP
The most commonly employed XForms command line options are also listed below
for the user's convenience:
.TP 8
.B \-name <appname>
Changes the application name. Useful for managing resources.
.TP 8
.B \-display <host:dpy>
Specifies the display server. The default value is that contained
in the $DISPLAY environment variable.
.TP 8
.B \-private
Forces xisp to use a private colormap.
.TP 8
.B \-shared
.br
Forces xisp to use a shared colormap.
.TP 8
.B \-stdcmap
Forces xisp to use the standard colormap.
.TP 8
.B \-bw <width in pixels>
Changes the default border width used by all XForms objects to
the desired value. The default border width is 3.
.SH FILES
.TP
.I "/usr/lib/ppp/options.xisp"
Default options file for the pppd daemon. It is not installed by
default as of version 1.8 of xisp. It can be used to pass pppd any
extra options not supported by xisp.
.TP
.I "/usr/lib/ppp/xispdial"
The special dialer program invoked by pppd 
as instructed by xisp. Employs chat(8) to converse with the modem
and if manual login is selected, launches xispterm enabling the
user to login manually.
.TP
.I "/usr/lib/ppp/xispterm"
A "bare bones" terminal emulation program invoked by xispdial
as a manual login terminal window.
.TP
.I "/usr/local/bin/xisprccv"
Utility program for converting .xisprc files of all older versions to
the latest format. Understands database formats of version 1.2 and later.
.TP
.I "$HOME/.xisprc"
Resource control file where xisp saves all its database information.
Plaintext passwords entered via xisp, are encrypted before being stored
in this file.
.TP
.I "$HOME/.xispscript"
Temporary file created by xisp and used by xispdial during the connection
phase. This file contains the plaintext password if automatic login via the
login script is selected, but is created u+rw,go-rw (mode 600) and remains
on the filesystem only for that limited amount of time required for
connection.
.TP
.I "$HOME/.xisppap"
Temporary file created by xisp and used by pppd, when PAP login is selected.
It contains the plaintext user account name and password, and is passed to
pppd via the +ua command line option. It is created u+rw,go-rw (mode 600)
and remains on the filesystem only for the short amount of time required for
pppd to parse its command line and spawn a copy of itself in the background.
Chances are that unless you have a very heavily loaded system, you'll never
be able to see this file in your home directory by using ls(1).
.TP
.I "/tmp/.xisppipe.<username>"
The named pipe node through which xispdial conveys messages to xisp. It
is created u+rw,go-rw (mode 600) and is not deleted when the user exits
xisp. The same node is also used for reading output from the ip-up and
ip-down scripts, called automatically by pppd when a link is set up or
torn down, respectively.
.SH "SEE ALSO"
pppd(8), chat(8).
.SH AUTHOR
The xisp package is authored and maintained by Dimitrios P. Bouras
<dbouras@hol.gr>. For more detailed contact information please read
the README file distributed with xisp.

.SH ACKNOWLEDGEMENTS
Thanks are due to the following individuals:
.TP
T.C. Zhao and Mark Overmars
.br
For creating the exceptional Forms
Library GUI. It's ease of use helped concentrating more on the
program parts doing the work rather those dealing with the
appearance of the user interface. Excellent work guys!
.TP
Luca Maranzano <liuk@kirk.linux.it>
.br
For putting together a packaged xisp for use with the Debian
Linux distribution.
.TP
I.Ioannou <roryt@hol.gr>
.br
For providing an alternative FTP site for the xisp distribution.
.TP
Peter T. Breuer <ptb@it.uc3m.es>
.br
For his help in extensively testing xisp on a *very* loaded
system and his contribution to the alternative pppd-PID
search code.
.TP
Raphael Wegmann <wegmann@ophelia.tuwien.ac.at>
.br
For providing the animated XPM icons and code that runs the
animation, for contributing code for the ip-up/ip-down support,
and all his great ideas on improving the functionality of xisp.
.TP
Doron Shikmoni <P85025@VM.BIU.AC.IL>
.br
For suggesting and then spending quite a bit of time testing
the call-back feature, as well as his ideas on improving the
scripting capabilities of xisp.
.TP
Ximenes Zalteca <ximenes@netset.com>
.br
For supporting the RPM source and binary packaging of xisp,
for use with the Red Hat Linux distribution.
.TP
Dave Holland <dave@zenda.demon.co.uk>
.br
for his extensive beta
testing of the I/O-driven call-back code, and his contribution
of perl code for parsing the ipparam string.
.TP
For their helpful feedback, suggestions and contributions
.br
Luca Maranzano <liuk@linux.it>
.br
Bogdan Bucicovschi <bogdanb@math.ohio-state.edu>
.br
Rich Lampe <rlampe@gate.cybernex.net>
.br
Peter T. Breuer <ptb@it.uc3m.es>
.br
Jon Davis <jon@mast.QueensU.CA>
.br
Steve Masticola <masticol@scr.siemens.com>
.br
I.Ioannou <roryt@hol.gr>
.br
Stuart Luppescu <s-luppescu@uchicago.edu>
.br
Amos Shapira <amos@dsi.co.il>
.br
Dan Morrison <danm@primenet.com>
.br
Raphael Wegmann <wegmann@ophelia.tuwien.ac.at>
.br
Jacob Spoelstra <jacob@padda.usc.edu
.br
Richard Marchelletta <rbm@ma.ultranet.com>
.br
Javier Ros <jros@upna.es>
.br
Stig <stig@hackvan.com>
.br
Daniel Whicker <heimdall@mail.utexas.edu>
.br
Charles Herman <cherman@acm.org>
.br
Doron Shikmoni <P85025@VM.BIU.AC.IL>
.br
Tom Hutchison <tomhutch@oregontrail.ne>
.br
Nik. I. Mouratidis <praeto@math.auth.gr>
.br
Dave Hoo <dhoo@flash.net>
.br
Stephan Hegel <ea273@fen.baynet.de>
.br
Geoffrey Leach <geoffrey@iname.com>
.br
Ximenes Zalteca <ximenes@netset.com>
.br
Dave Holland <dave@zenda.demon.co.uk>
.br
Henning Schmiedehausen <henning@forge.franken.de>
.SH COPYRIGHT
xisp is Copyright (C) 1997  Dimitrios P. Bouras
.PP
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
