/*
  Copyright (C) 1997  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

/* Callbacks */

void doConnect(FL_OBJECT *, long);
void doInterrupt(FL_OBJECT *, long);
void doDisconnect(FL_OBJECT *, long);
void doQuit(FL_OBJECT *, long);
void doOptions(FL_OBJECT *, long);
void doHelp(FL_OBJECT *, long);
void doAutoRedial(FL_OBJECT *, long);

void doTelNoInput(FL_OBJECT *, long);
void doAccountInput(FL_OBJECT *, long);
void doPasswdInput(FL_OBJECT *, long);
void doUNInput(FL_OBJECT *, long);
void doRemoteInput(FL_OBJECT *, long);
void doAuthPAPButton(FL_OBJECT *, long);
void doAuthNoneButton(FL_OBJECT *, long);
void doAuthPAPSButton(FL_OBJECT *, long);
void doAuthCHAPSButton(FL_OBJECT *, long);
void doAccountOK(FL_OBJECT *, long);
void doAccountCancel(FL_OBJECT *, long);

void doRetryInput(FL_OBJECT *, long);
void doDelayInput(FL_OBJECT *, long);
void doTTYesButton(FL_OBJECT *, long);
void doTTNoButton(FL_OBJECT *, long);
void doCBYesButton(FL_OBJECT *, long);
void doCBOptions(FL_OBJECT *, long);
void doScriptInput(FL_OBJECT *, long);
void doCNWaitInput(FL_OBJECT *, long);
void doRBYesButton(FL_OBJECT *, long);
void doRBNoButton(FL_OBJECT *, long);
void doDialOK(FL_OBJECT *, long);
void doDialCancel(FL_OBJECT *, long);

void doCBInfoOK(FL_OBJECT *, long);
void doCBInfoCancel(FL_OBJECT *, long);
void doCBScriptInput(FL_OBJECT *, long);
void doCBDelayInput(FL_OBJECT *, long);

void doISPPick(FL_OBJECT *, long);
void doISPPickNEdit(FL_OBJECT *, long);
void doISPNameEdit(FL_OBJECT *, long);
void doISPOK(FL_OBJECT *, long);
void doISPCancel(FL_OBJECT *, long);

void doISPNameInput(FL_OBJECT *, long);
void doISPNameEditOK(FL_OBJECT *, long);
void doISPNameEditCancel(FL_OBJECT *, long);

void doExitOK(FL_OBJECT *, long);
void doExitCancel(FL_OBJECT *, long);

void doAboutOK(FL_OBJECT *, long);
void doHelpInfoOK(FL_OBJECT *, long);

void doCommInfoOK(FL_OBJECT *, long);
void doCommInfoCancel(FL_OBJECT *, long);
void doDeviceInput(FL_OBJECT *, long);
void doModemInitInput(FL_OBJECT *, long);
void doModemResetInput(FL_OBJECT *, long);
void doToneButton(FL_OBJECT *, long);
void doPulseButton(FL_OBJECT *, long);
void doSWCOnButton(FL_OBJECT *, long);
void doSWCOffButton(FL_OBJECT *, long);
void doSpeedButton(FL_OBJECT *, long);
void doSWCInput(FL_OBJECT *, long);
void doAsyncmapInput(FL_OBJECT *, long);
void doEscapeYesButton(FL_OBJECT *, long);
void doEscapeNoButton(FL_OBJECT *, long);
void doEscapeInput(FL_OBJECT *, long);
void doHWButton(FL_OBJECT *, long);
void doSWButton(FL_OBJECT *, long);

void doLocalIPInput(FL_OBJECT *, long);
void doALYesButton(FL_OBJECT *, long);
void doALNoButton(FL_OBJECT *, long);
void doRemoteIPInput(FL_OBJECT *, long);
void doARYesButton(FL_OBJECT *, long);
void doARNoButton(FL_OBJECT *, long);
void doTcpipInfoOK(FL_OBJECT *, long);
void doCommInfoCancel(FL_OBJECT *, long);
void doDRYesButton(FL_OBJECT *, long);
void doDRNoButton(FL_OBJECT *, long);
void doRemoteNMInput(FL_OBJECT *, long);
void doMTUInput(FL_OBJECT *, long);
void doMRUInput(FL_OBJECT *, long);
void doUDYesButton(FL_OBJECT *, long);
void doUDNoButton(FL_OBJECT *, long);
void doPDNSInput(FL_OBJECT *, long);
void doSDNSInput(FL_OBJECT *, long);

/* Forms and Objects */

#define OPTIONS_ISP     1
#define OPTIONS_ACCOUNT 2
#define OPTIONS_DIALING 3
#define OPTIONS_COMM    4
#define OPTIONS_TCPIP   5
#define HELP_ABOUT 1
#define HELP_GENERAL 2

typedef struct {
	FL_FORM *topFrame;
	FL_OBJECT *conButton;
	FL_OBJECT *intButton;
	FL_OBJECT *disButton;
	FL_OBJECT *quitButton;
	FL_OBJECT *optMenu;
	FL_OBJECT *hlpMenu;
	FL_OBJECT *lstBrowser;
	FL_OBJECT *timeText;
	FL_OBJECT *speedText;
	FL_OBJECT *IPText;
	FL_OBJECT *statusText;
	FL_OBJECT *topIcon;
	FL_OBJECT *ISPText;
	FL_OBJECT *autoRedial;
	void *vdata;
	long ldata;
} FD_topFrame;
FD_topFrame * create_form_topFrame(void);

typedef struct {
	FL_FORM *accountInfo;
	FL_OBJECT *telInput;
	FL_OBJECT *accInput;
	FL_OBJECT *pswInput;
	FL_OBJECT *UNInput;
	FL_OBJECT *remoteInput;
	FL_OBJECT *authType;
	FL_OBJECT *authPAPButton;
	FL_OBJECT *authNoneButton;
	FL_OBJECT *authPAPSButton;
	FL_OBJECT *authCHAPSButton;
	FL_OBJECT *accOK;
	FL_OBJECT *accCancel;
	void *vdata;
	long ldata;
} FD_accountInfo;
FD_accountInfo * create_form_accountInfo(void);

typedef struct {
	FL_FORM *dialInfo;
	FL_OBJECT *rtrInput;
	FL_OBJECT *dlyInput;
	FL_OBJECT *CNWaitInput;
	FL_OBJECT *TTGroup;
	FL_OBJECT *TTYesButton;
	FL_OBJECT *TTNoButton;
	FL_OBJECT *RBGroup;
	FL_OBJECT *RBYesButton;
	FL_OBJECT *RBNoButton;
	FL_OBJECT *CBGroup;
	FL_OBJECT *CBYesButton;
	FL_OBJECT *CBOptions;
	FL_OBJECT *EscriptLine[MAXNUM_SLINES];
	FL_OBJECT *SscriptLine[MAXNUM_SLINES];
	FL_OBJECT *dialOK;
	FL_OBJECT *dialCancel;
	void *vdata;
	long ldata;
} FD_dialInfo;
FD_dialInfo * create_form_dialInfo(void);

typedef struct {
	FL_FORM *CBInfo;
	void *vdata;
	long ldata;
	FL_OBJECT *CBInfoOK;
	FL_OBJECT *CBInfoCancel;
	FL_OBJECT *CBdlyInput;
	FL_OBJECT *CBEscriptLine[8];
	FL_OBJECT *CBSscriptLine[8];
} FD_CBInfo;
FD_CBInfo * create_form_CBInfo(void);

typedef struct {
	FL_FORM *ISPInfo;
	FL_OBJECT *ISPBrowser;
	FL_OBJECT *ISPOK;
	FL_OBJECT *ISPCancel;
	FL_OBJECT *ISPNameEdit;
	void *vdata;
	long ldata;
} FD_ISPInfo;
FD_ISPInfo * create_form_ISPInfo(void);

typedef struct {
	FL_FORM *renameISP;
	FL_OBJECT *ISPNameInput;
	FL_OBJECT *ISPNameEditOK;
	FL_OBJECT *ISPNameEditCancel;
	void *vdata;
	long ldata;
} FD_renameISP;
FD_renameISP * create_form_renameISP(void);

typedef struct {
	FL_FORM *aboutInfo;
	FL_OBJECT *aboutOK;
	void *vdata;
	long ldata;
} FD_aboutInfo;
FD_aboutInfo * create_form_aboutInfo(void);

typedef struct {
	FL_FORM *exitDialog;
	FL_OBJECT *exitOK;
	FL_OBJECT *exitCancel;
	void *vdata;
	long ldata;
} FD_exitDialog;
FD_exitDialog * create_form_exitDialog(void);

typedef struct {
	FL_FORM *helpInfo;
	FL_OBJECT *helpBrowser;
	FL_OBJECT *helpInfoOK;
	void *vdata;
	long ldata;
} FD_helpInfo;
FD_helpInfo * create_form_helpInfo(void);

typedef struct {
	FL_FORM *commInfo;
	FL_OBJECT *commInfoOK;
	FL_OBJECT *commInfoCancel;
	FL_OBJECT *modemInitInput;
	FL_OBJECT *modemResetInput;
	FL_OBJECT *modemDialType;
	FL_OBJECT *toneButton;
	FL_OBJECT *pulseButton;
	FL_OBJECT *SWCType;
	FL_OBJECT *SWCOnButton;
	FL_OBJECT *SWCOffButton;
	FL_OBJECT *deviceInput;
	FL_OBJECT *modemSpeedType;
	FL_OBJECT *speedButton[8];
	FL_OBJECT *SWCInput;
	FL_OBJECT *asyncmapInput;
	FL_OBJECT *escapeType;
	FL_OBJECT *escapeYesButton;
	FL_OBJECT *escapeNoButton;
	FL_OBJECT *escapeInput;
	FL_OBJECT *flowCtrlType;
	FL_OBJECT *HWButton;
	FL_OBJECT *SWButton;
	void *vdata;
	long ldata;
} FD_commInfo;
FD_commInfo * create_form_commInfo(void);

typedef struct {
	FL_FORM *tcpipInfo;
	FL_OBJECT *localIPInput;
	FL_OBJECT *ALTypeGroup;
	FL_OBJECT *ALYesButton;
	FL_OBJECT *ALNoButton;
	FL_OBJECT *remoteIPInput;
	FL_OBJECT *ARTypeGroup;
	FL_OBJECT *ARYesButton;
	FL_OBJECT *ARNoButton;
	FL_OBJECT *tcpipInfoOK;
	FL_OBJECT *tcpipInfoCancel;
	FL_OBJECT *DRTypeGroup;
	FL_OBJECT *DRYesButton;
	FL_OBJECT *DRNoButton;
	FL_OBJECT *UDTypeGroup;
	FL_OBJECT *UDYesButton;
	FL_OBJECT *UDNoButton;
	FL_OBJECT *NMInput;
	FL_OBJECT *MTUInput;
	FL_OBJECT *MRUInput;
	FL_OBJECT *pDNSInput;
	FL_OBJECT *sDNSInput;
	void *vdata;
	long ldata;
} FD_tcpipInfo;
FD_tcpipInfo * create_form_tcpipInfo(void);

/* Other xISP defines */

#define BU_INTERVAL   2.0	/* check dialer output every 1 second */
#define CT_INTERVAL   5.0	/* update connection time every 5 seconds */
#define SP_INTERVAL  15.0	/* check link status every 15 seconds */
#define DIAL_WAIT    30.0	/* max wait seconds for xispdial to open pipe */
#define UD_WAIT      16.0	/* max wait for ip-up/-down output in pipe */
#ifdef XPMANIMATE
#define XPM_INTERVAL  0.3	/* XPM animation trigger interval */
#endif

typedef struct {			/* the color structure */
	int r, g, b;
} color_t;

#define BGCOL_DEFAULT {0, 139, 139}	/* default form-background color */
#define BGCOL_STRING  "#008B8B"

#define DISCONNECTED 0		/* to specify xISP state */
#define DIALING      1
#define CONNECTED    2

#define EMPTY_TIME  "00:00:00"
#define EMPTY_IP    "---.---.---.---"
#define EMPTY_SPEED "--,---"

