/*
  Copyright (C) 1997  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

/* Constants for xisp and xispdial */

#define MAXNUM_ISP       8	/* number of configurations in options file */
#define MAXLEN_DESCR    32	/* configuration description string length */
#define MAXLEN_PHONE    32	/* phone string length */
#define MAXNUM_TELS      8	/* telephone numbers in options */
#define MAXLEN_ACCOUNT  32	/* account number of characters */
#define MAXLEN_PASSWD   32	/* password characters */
#define MAXLEN_UNR      32	/* name/user/remote pppd opt arg maximum chars */ 
#define MAXDIG_RETRY     3	/* number of retries maximum digits */
#define MAXDIG_DELAY     3	/* inter-dialing delay seconds # maximum digits */
#define MAXDIG_CNWAIT    3	/* connection wait seconds # of digits */
#define MAXDIG_CBDELAY   3	/* call-back delay seconds # maximum digits */
#define MAXNUM_SLINES    8	/* number of saved script lines */
#define MAXLEN_SLINE    32	/* characters in each script line */
#define MAXLEN_MODEM    64	/* modem initialization string length */
#define MAXLEN_DEVICE   16	/* modem device name string length */
#define MAXDIG_BSDCOMP   2	/* BSD compression level number digits */
#define MAXDIG_ASYNCMAP  8	/* pppd asyncmap number of digits */
#define MAXLEN_ESCAPE   16	/* pppd escape character list length */
#define MAXLEN_IP       15	/* all IP input strings length */
#define MAXDIG_MTRU      4	/* MTU and MRU maximum number of digits */
#define MAXLEN_TTPARM   64	/* xispterm parameter string maximum length */

/* xISP file names */

#define RCFNAME		".xisprc"		/* for all program options */
#define PIPEFNAME	".xisppipe"		/* named pipe for reporting */
#define ENVFNAME	".xispenv"		/* generated dialer environment */
#define SCRIPTFNAME	".xispscript"	/* generated dialing script */
#define PAPFNAME	".xisppap"		/* the login data file for PAP */

/* Chat/PPPD interface defines */

#define CHAT		 BINPATH "/chat"			/* chat executable */
#define PPPD         BINPATH "/pppd"			/* pppd executable */
#define PPPD_OPTIONS OPTPATH "/options.xisp"	/* default options file */
#define PPPD_CONNECT LIBPATH "/xispdial"		/* pppd connect prog */
#define TERMINAL     LIBPATH "/xispterm"		/* manual login terminal */

#define MAXBUF_CHILD   128	/* buffer size for dialer output reads by xISP */
#define MAXNUM_RETRY   10	/* default total number of dialing tries */
#define MAXSEC_DELAY   5	/* default delay between dials */
#define MAXSEC_CBDELAY 60	/* default delay for call-back wait */
#define MAXSEC_CNWAIT  50	/* default maximum wait for modem connection */

/* Modem and communication defines */

#define MODEM_DEVICE   "/dev/modem"			/* default modem device */
#define MS_1200        0x01					/* selectable DTE<->DCE speeds */
#define MS_2400        0x02
#define MS_4800        0x04
#define MS_9600        0x08
#define MS_19200       0x10
#define MS_38400       0x20
#define MS_57600       0x40
#define MS_115200      0x80
#define MODEM_SPEED    MS_38400				/* 38400 Baud set by default */
#define MODEM_INIT	   "AT"					/* default init string */
#define MODEM_RESET	   "ATZ"				/* default reset string */
#define BSDCOMP        "bsdcomp"			/* pppd BSD compression options */
#define COMP_LEVEL     12
#define PPPD_SASYNCMAP "20A0000"			/* pppd asyncmap for software */
#define PPPD_HASYNCMAP "00"					/* and hardware flow contol */
#define PPPD_ESCAPE    "FF"					/* default pppd escape list */

/* TCP/IP defines */

#define LOCAL_IP     "\x00\x00\x00\x00"		/* default local IP address */
#define LOCAL_IPSTR  "0.0.0.0"
#define REMOTE_IP    "\x00\x00\x00\x00"		/* default remote IP address */
#define REMOTE_IPSTR "0.0.0.0"
#define NETMASK      "\xFF\xFF\xFF\x00"		/* default netmask */
#define NETMASKSTR   "255.255.255.0"
#define DNS          "\x00\x00\x00\x00"		/* default DNS address */
#define DNS_IPSTR    "0.0.0.0"
#define MTU          1500					/* MTU and MRU defaults */
#define MRU          1500

/* Operating mode options flags */

#define MODEM_TONEDIAL	0x0001
#define PPPD_COMPRESS	0x0002
#define HW_FLOWCTRL		0x0004
#define ACCEPT_LOCALIP	0x0008
#define ACCEPT_REMOTEIP	0x0010
#define DEFAULT_ROUTE	0x0020
#define MANUAL_LOGIN	0x0040
#define PAP_LOGIN		0x0080
#define AUTO_REDIAL		0x0100
#define CALL_BACK		0x0200
#define ESCAPE_ON		0x0400
#define IP_UPDOWN		0x0800
#define PAPS_LOGIN		0x1000
#define CHAPS_LOGIN		0x2000
#define CONNECT_BELL	0x4000

/* Default operating mode */

#define OPER_OPTS (MODEM_TONEDIAL|PPPD_COMPRESS|HW_FLOWCTRL| \
				   ACCEPT_LOCALIP|ACCEPT_REMOTEIP|DEFAULT_ROUTE)

/* The data file structure for all xisp options */

typedef struct {
	char descr[MAXLEN_DESCR+1];					/* ISP entry description */
	char account[MAXLEN_ACCOUNT+1];				/* user account name */
	char passwd[MAXLEN_PASSWD+1];				/* and password */
	char name[MAXLEN_UNR+1];					/* name/user pppd arg */
	char rname[MAXLEN_UNR+1];					/* and remotename pppd arg */
	unsigned char maxAttempts;					/* maximum dialing attempts */
	unsigned char sleepDelay;					/* delay between dials */
	unsigned char connectWait;					/* maximum wait for connect */
	unsigned char numPhones;					/* # of phone-number entries */
	char phone[MAXNUM_TELS][MAXLEN_PHONE+1];	/* phone number table */
	unsigned char numSlines;					/* # of script lines */
	char sline[2*MAXNUM_SLINES][MAXLEN_SLINE+1];/* script line table */
	unsigned char CBDelay;						/* delay for call-back dials */
	unsigned char numCBSlns;					/* # call-back script lines */
	char CBsln[2*MAXNUM_SLINES][MAXLEN_SLINE+1];/* call-back script table */
	char modemDevice[MAXLEN_DEVICE+1];			/* modem device path */
	unsigned char modemSpeed;					/* DTE<->DCE speed */
	char modemReset[MAXLEN_MODEM+1];			/* modem reset string */
	char modemInit[MAXLEN_MODEM+1];				/* modem init string */
	unsigned short operOpts;					/* operating options word */
	unsigned char compLevel;					/* SW compression level */
	char asyncmap[MAXDIG_ASYNCMAP+1];			/* pppd asyncmap */
	char escape[MAXLEN_ESCAPE+1];				/* and escape options */
	unsigned char localIP[4];					/* local IP entry */
	unsigned char remoteIP[4];					/* remote IP entry */
	unsigned char netmask[4];					/* netmask entry */
	unsigned char dns1[4];						/* primary DNS entry */
	unsigned char dns2[4];						/* secondary DNS entry */
	unsigned int mtu;							/* the MTU */
	unsigned int mru;							/* and the MRU */
} xisprc_t;

#define XISPRC_DEFAULT {{0},{0},{0},{0},{0},MAXNUM_RETRY,MAXSEC_DELAY,\
						MAXSEC_CNWAIT,0,{{0}},0,{{0}},MAXSEC_CBDELAY,0,{{0}},\
						{0},MODEM_SPEED,MODEM_RESET,MODEM_INIT,OPER_OPTS,\
						COMP_LEVEL,PPPD_HASYNCMAP,PPPD_ESCAPE,\
						LOCAL_IP,REMOTE_IP,NETMASK,DNS,DNS,MTU,MRU}

