// pppload - A PPP Load Monitor
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _Options_H_
#define _Options_H_

#include <qcolor.h>
#include <qstring.h>

//: Parse and store command line options.
class Options {
	//: Command to bring up the PPP link.
	QString _cmd;
	//: Sapcing between horizontal dividers.
	int     _divider;
	//: Statistics polling interval in seconds.
	int     _interval;
	//: PPP link number to monitor.
	int     _link;
	//: Load averaging interval in seconds.
	int     _period;
	//: Time between retries when dialling PPP link.
	int     _retry;
	//: True means display transmit stats.
	bool    _showTx;
	//: True means display receive stats.
	bool    _showRx;
	//: Color for transmit stats.
	QColor  _txColor;
	//: Color for receive stats.
	QColor  _rxColor;
 public:
	//: Extract command line opotions from argc and argv.
	Options( int argc, char* argv[] );

    //: Return the PPP command.
    QString& cmd()      { return _cmd;      }
	
	//: Return the spacing between horizontal dividers.
	int      divider()  { return _divider;  }

	//: Return the statistics polling interval.
	int      interval() { return _interval; }
	
	//: Return the PPP link number to monitor.
	int      link()     { return _link;     }
	
	//: Return the load averaging period.
	int      period()   { return _period;   }
	
	//: Return the time betweem PPP link dialling retries.
	int      retry()    { return _retry;    }
	
	//: Return the transmit stats flag.
	bool     showTx()   { return _showTx;   }
	
	//: Return the receive stats flag.
	bool     showRx()   { return _showRx;   }
	
	//: Return the transmit color.
	QColor&  txColor()  { return _txColor;  }
	
	//: Return the receive color.
	QColor&  rxColor()  { return _rxColor;  }
};

extern Options* options;

#endif
