.\" 
.\" Genscript manual page.
.\" Copyright (c) 1995 Markku Rossi.
.\" Author: Markku Rossi <mtr@iki.fi>
.\"
.\"
.\" This file is part of genscript.
.\" 
.\" Genscript is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2, or (at your option)
.\" any later version.
.\"
.\" Genscript is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with genscript; see the file COPYING.  If not, write to
.\" the Free Software Foundation, 59 Temple Place - Suite 330,
.\" Boston, MA 02111-1307, USA.
.\"
.TH GENSCRIPT 1 "Oct 26, 1995" "GENSCRIPT" "GENSCRIPT"

.SH NAME
genscript \- convert ASCII files to PostScript

.SH SYNOPSIS
.B genscript
[\f3\-12BcCegGhlmOqrRvVZ] 
[\f3\-b \f2header\f1] 
[\f3\-d \f2queue\f1] 
[\f3\-D \f2key\f1[\f3:\f2value\f1]] 
[\f3\-f \f2font\f1] 
[\f3\-F \f2header_font\f1] 
[\f3\-i \f2indent\f1]
[\f3\-L \f2lines_per_page\f1] 
[\f3\-M \f2media\f1] 
[\f3\-n \f2copies\f1] 
[\f3\-N \f2newline\f1] 
[\f3\-o \f2outputfile\f1] 
[\f3\-o \-\f1] 
[\f3\-p \f2outputfile\f1] 
[\f3\-p \-\f1] 
[\f3\-P \f2queue\f1] 
[\f3\-s \f2baselineskip\f1] 
[\f3\-S \f2key\f1[\f3:\f2value\f1]] 
[\f3\-t \f2title\f1] 
[\f3\-T \f2tab_size\f1] 
[\f3\-u \f2text\f1]
[\f3\-X \f2encoding\f1]
[\f2filename\f1 ...]

.SH DESCRIPTION

\f3Genscript\f1 converts ASCII files to PostScript and spools
generated PostScript output to the specified printer or leaves it to
file.  \f3Genscript\f1 can be easily extended to handle different
output media and it has many options which can be used to customize
printouts.

.SH OPTIONS
.TP 8
.B \-1, \-2, \-\-columns=\f2num\f3
Specify how many columns each page have.  

\f3Note!\f1 with long option \f3\-\-columns=\f2num\f1 you can specify
more than 2 columns per page.
.TP 8
.B \-b \f2header\f3, \-\-page\-header=\f2header\f3
Use text \f2header\f1 as a page header.  This works only for simple
(non\-fancy) page headers.  The default page header is constructed from
file's name and last modification time. 
.TP 8
.B \-B, \-\-no\-header
Do not print page headers.
.TP 8
.B \-c, \-\-truncate\-lines
Cut lines that are too long.  As a default, \f3genscript\f1 wraps long
lines so no information is lost.
.TP 8
.B \-C, \-\-line\-numbers
Precede each line with its line number.
.TP 8
.B \-d \f2queue\f3 
Spool output to the printer queue \f2queue\f1.
.TP 8
.B \-D \f2key\f1[\f3:\f2value\f1]\f3, \-\-setpagedevice=\f2key\f1[\f3:\f2value\f1]\f3
Pass a page device definition to the generated PostScript output.  If
no value is given, key \f2key\f1 is removed from definitions.

For example, command

.B genscript \-DDuplex:true foo.txt

prints file foo.txt in duplex (two side) mode.

Page device operators are implementation dependant but they are
standardized.  See section \f3PAGE DEVICE OPTIONS\f1 for details.
.TP 8
.B \-e, \-\-special\-escapes
Enable special escapes interpretation (see section \f3SPECIAL
ESCAPES\f1).
.TP 8
.B \-f \f2name\f3, \-\-font=\f2name\f3
Select font that is used for body text.  Font specification \f2name\f1
contains two parts: font's name and font's size in points.  For
example "\f3Times\-Roman12\f1" selects "Times\-Roman" font with size
12pt.  

The default body font is \f2Courier10\f1, unless multicolumn landscape
printing mode is selected, in which case the default is
\f2Courier7\f1.

\f3Note!\f1 font's size can be given as a decimal number.  For example
"\f3Times\-Roman10.2\f1" selects 10.2pt "Times\-Roman" font.
.TP 8
.B \-F \f2name\f3, \-\-header\-font=\f2name\f3
Select font for header texts.
.TP 8
.B \-g, \-\-print\-anyway
Print file even if it contains binary data.  Option is here only for
compatibility since \f3genscript\f1 prints binary files anyway.
.TP 8
.B \-G, \-\-fancy\-header\f1[\f3=\f2name\f1]\f3
Print fancy page header \f2name\f1 to top of each page.  Option
\f3\-G\f1 specifies the default fancy header (see section
\f3CONFIGURATION FILES\f1 to see how the default fancy header can be
changed).
.TP 8
.B \-h, \-\-help
Print short help and exit.
.TP 8
.B \-i \f2num\f3, \-\-indent=\f2num\f3
Indent every line \f2num\f1 characters.
.TP 8
.B \-l, \-\-lineprinter
Emulate lineprinter.  This option is a shortcut for options: 
\f3\-\-lines\-per\-page=65\f1, \f3\-\-no\-header\f1, \f3\-\-portrait\f1,
\f3\-\-columns=1\f1. 
.TP 8
.B \-L \f2num\f3, \-\-lines\-per\-page=\f2num\f3
Print only \f2num\f1 lines per each page. 
.TP 8
.B \-m, \-\-mail
Send mail notification to user after print job has been completed. 
.TP 8
.B \-M \f2name\f3, \-\-media=\f2name\f3
Select output media \f2name\f1.  \f3Genscript\f1's default output
media is \f3A4\f1. 
.TP 8
.B \-n \f2num\f3, \-\-copies=\f2num\f3
Print \f2num\f1 copies of each page.
.TP 8
.B \-N \f2nl\f3, \-\-newline=\f2nl\f3
Select the \f2newline\f1 character.  Possible values for \f2nl\f1 are:
\f3n\f1 (unix newline, 0xa hex) and \f3r\f1 (mac newline, 0xd hex).
.TP 8
.B \-o \f2file\f3
An alias for option \f3\-p\f1, \f3\-\-output\-file\f1.
.TP 8
.B \-O, \-\-list\-missing\-characters
Print a listing of character codes that couldn't be printed.
.TP 8
.B \-p \f2file\f3, \-\-output\-file=\f2file\f3
Leave output to file \f2file\f1.  If \f2file\f1 is `\-', leave output
to \f2stdout\f1.
.TP 8
.B \-P \f2queue\f3, \-\-queue=\f2queue\f3
Spool output to the printer queue \f2queue\f1.
.TP 8
.B \-q, \-\-quiet
Make \f3genscript\f1 really quiet.  Only fatal error messages are
printed to \f2stderr\f1.
.TP 8
.B \-r, \-\-landscape
Print in landscape mode; rotate page 90 degrees.
.TP 8
.B \-R, \-\-portrait
Print in portrait mode (default).
.TP 8
.B \-s \f2num\f3, \-\-baselineskip=\f2num\f3
Specify the baseline skip in PostScript points.  Number \f2num\f1 can
be given as a decimal number.  When \f3genscript\f1 moves from line to
line, current point \f2y\f1 coordinate is moved (\f2font point size +
baselineskip\f1) points down (the default baselineskip is 1).
.TP 8
.B \-S \f2key\f1[\f3:\f2value\f1]\f3, \-\-statusdict=\f2key\f1[\f3:\f2value\f1]\f3
Pass a statusdict definition to the generated PostScript output.  If
no value is given, key \f2key\f1 is removed from definitions.

Statusdict operators are implementation dependant; see printer's
documentation for details.

For example, command 

.B genscript \-Ssetpapertray:1 foo.txt

prints file \f2foo.txt\f1 by using paper from the paper tray 1
(assuming that printer supports paper tray selection).
.TP 8
.B \-t \f2title\f3, \-\-title=\f2title\f3
Set banner page's job title to \f2title\f1.
.TP 8
.B \-T \f2num\f3, \-\-tab\-size=\f2num\f3
Set tabulator size to \f2num\f1 (default is 8).
.TP 8
.B \-u \f2text\f3, \-\-underlay=\f2text\f3
Print string \f2text\f1 under every page.  Text's properties can be
changed with options \f3\-\-ul\-font\f1 and \f3\-\-ul\-gray\f1.
.TP 8
.B \-v, \-\-verbose\f1[\f3=\f2level\f1]\f3
Tell what \f3genscript\f1 is doing.
.TP 8
.B \-V, \-\-version
Print \f3genscript\f1 version and exit.
.TP 8
.B \-X \f2name\f3, \-\-encoding=\f2name\f3
Use input encoding \f2name\f1.  Currently \f3genscript\f1 supports
following encodings:
.RS 8
.TP 8
.B latin1
ISO\-8859/1 (ISO latin1) (\f3genscript\f1's default encoding).
.TP 8
.B latin2
ISO\-8859/2 (ISO latin2)
.TP 8
.B ascii
7\-bit ascii
.TP 8
.B asciiscands
7\-bit ascii with some scandinavian extensions
.TP 8
.B ibmpc
IBM PC charset
.TP 8
.B mac
Mac charset
.TP 8
.B vms
VMS multinational charset
.TP 8
.B ps
PostScript font's default encoding
.RE
.TP 8
.B \-Z, \-\-pass\-through\-ps\-files
Pass through all PostScript files without any modifications.  This
allows that \f3genscript\f1 can be used as a lp filter.  PostScript
files are recognized by looking up the `%!' magic cookie from the
beginning of the file. \f3Note!\f1 \f3Genscript\f1 recognized also the
Windoze damaged `^D%!' cookie.
.TP 8
.B \-\-download\-font=\f2fontname\f3
Include the font description file (\f2.pfa\f1 or \f2.pfb\f1 file) of
the font \f2fontname\f1 to the generated output.
.TP 8
.B \-\-list\-media
List the names of all known output media and exit successfully.
.TP 8
.B \-\-list\-options
List all options and their current values.  Exit successfully.
.TP 8
.B \-\-page\-label\-format=\f2format\f3
Set page label format to \f2format\f1.  Page label format specifies
how labels for the `%%Page:' comments are formatted.  Possible values
are:
.RS 8
.TP 8
.B short
Print only page number: `%%Page: (1) 1' (default)
.TP 8
.B long
Print current filename and pagenumber within
file: `%%Page: (main.c:  1) 1'
.RE
.TP 8
.B \-\-ul\-font=\f2name\f3
Select font for the underlay text.
.TP 8
.B \-\-ul\-gray=\f2num\f3
Print underlay text with gray value \f2num\f1 (0 ... 1), the default
gray is .8.

.SH CONFIGURATION FILES

.B Genscript 
reads configuration information from following sources (in this
order): command line options, environment variables \f3GENSCRIPT\f1
and \f3ENSCRIPT\f1, user's configuration file
(\f3$HOME/.genscriptrc\f1) and system's global configuration file
(\f2prefix\f3/lib/genscript/genscript.cfg\f1).

The configuration files has the following format:

Empty lines and lines starting with `#' are comments.

All other lines are option lines and have format: 

\f2OPTION\f1 [\f2arguments ...\f1]. 

Following options can be specified:
.TP 8
.B AFMPath: \f2path\f3
Specifies search path for the \f2AFM\f1 files. 
.TP 8
.B DefaultEncoding: \f2name\f3
Select the default input encoding.  Encoding name \f2name\f1 can be
one of the values of the \f3\-X\f1, \f3\-\-encoding\f1 option.
.TP 8
.B DefaultFancyHeader: \f2name\f3
Select the default fancy header.  Default header is used when option
\f3\-G\f1 is specified or option \f3\-\-fancy\-header\f1 is given without
an argument.  System\-wide default is `\f3enscript\f1'.
.TP 8
.B DefaultMedia: \f2name\f3
Select the default output media.
.TP 8
.B DefaultOutputMethod: \f2method\f3
Select the default target to which generated output is send.  Possible
values for \f2method\f1 are:
.RS 8
.TP 8
.B printer
send output to printer
.TP 8
.B stdout
send output to \f2stdout\f1
.RE
.TP 8
.B DownloadFont: \f2fontname\f1
Include the font description file of the font \f2fontname\f1 to the
generated output.
.TP 8
.B LibraryPath: \f2path\f3
Specifies \f3genscript\f1's library path that is used to lookup
various resources.  Default path is:
`\f2prefix\f1/lib/genscript:\f2home\f1/.genscript'.  Where
\f2prefix\f1 is the installation prefix (usually /usr/local) and
\f2home\f1 is the user's home directory.
.TP 8
\f3Media: \f2name\f3 \f2width\f3 \f2height\f3 \f2llx\f3 \f2lly\f3 \f2urx\f3 \f2ury\f3
Add a new output media with name \f2name\f1.  Media's physical
dimensions are \f2width\f1 and \f2height\f1.  Media's bouding box is
specified by points (\f2llx\f1, \f2lly\f1) and (\f2urx\f1, \f2ury\f1).
.B Genscript 
prints all graphics inside media's bouding box.  

User can select this media by giving option \f3\-M \f2name\f1.
.TP 8
.B PageLabelFormat: \f2format\f1
Set page label format to \f2format\f1.  Possible values for
\f2format\f1 are the same that can be given to the
\f3\-\-page\-label\-format\f1 option.
.TP 8
.B Queue: \f2name\f3
Names the printer queue to spool to.
.TP 8
.B QueueParam: \f2name\f3
The spooler command switch for the printer queue, e.g. \f2\-P\f1 in
\f2lpr \-Pps\f1.
.TP 8
.B SetPageDevice: \f2key\f1[\f3:\f2value\f1]\f3
Pass a page device definition to the generated PostScript output.
.TP 8
.B Spooler: \f2name\f3
Names printer spooler command.  \f3Genscript\f1 pipes generated
PostScript to command \f2name\f1.
.TP 8
.B StatusDict: \f2key\f1[\f3:\f2value\f1]\f3
Pass a statusdict definition to the generated PostScript output.

.SH CUSTOMIZATION

Users can create their own fancy headers by creating a header
description file and placing it in a directory that is in
\f3genscript\f1's library path.  The name of the header file must be
in format: `\f2headername\f1.hdr'.  Header can be used by giving
option: \f3\-\-fancy\-header=\f2headername\f1.

Header description file contains PostScript code that paints the
header.  Description file must provide procedure \f3do_header\f1 which
is called by \f3genscript\f1 at the beginning of every page.

Header description file contains two parts: comments and code.  Parts
are separated by a line containing text: 

% \-\- code follows this line \-\-

.B Genscript
copies only the code part of description file to the generated
PostScript output.  The comments part can contain any data, it is not
copied.  If separator line is missing, no data is copied to output.

.B Genscript 
defines following constants that can be used in header description
files: 
.TP 16
.B  d_page_w	
page width
.TP 16
.B  d_page_h	
page height
.TP 16
.B  d_header_x	
header lower left \f2x\f1 coordinate
.TP 16
.B  d_header_y	
header lower left \f2y\f1 coordinate
.TP 16
.B  d_header_w	
header width
.TP 16
.B  d_header_h	
header height
.TP 16
.B  d_output_w	
output width (~ \f3d_page_w\f1)
.TP 16
.B  d_output_h	
output height (~ \f3d_page_h\f1 \- \f3d_header_h\f1)
.TP 16
.B  usadatestr	
date in USA format: \f2MM\f1/\f2DD\f1/\f2YY\f1
.TP 16
.B  eurdatestr  
date in european format: \f2YY\f1/\f2MM\f1/\f2DD\f1
.TP 16
.B findatestr
date in finnish format: \f2DD\f1.\f2MM\f1.\f2YYYY\f1
.TP 16
.B  timestr	
current time: \f2HH\f1:\f2MM\f1:\f2SS\f1
.TP 16
.B  user_header_p	
predicate that tells if user has defined his/her own header string:
\f3true\f1/\f3false\f1
.TP 16
.B  user_header_str	
if \f3user_header_p\f1 is \f3true\f1, this is the user supplied header
string. 
.TP 16
.B  HF		
standard header font (from \f3\-F\f1, \f3\-\-header\-font\f1 option).
This can be selected simply by invoking command: `\f3HF setfont\f1'.
.TP 16
.B pagenum
the number of the current page 
.TP 16
.B fname
the full name of the printed file (/foo/bar.c)
.TP 16
.B fdir
the directory part of the file name (/foo)
.TP 16
.B ftail
file name without the directory part (bar.c)
.TP 16
.B fmodstr
file's last modification time in format `\f2Thu Aug 17 09:05:20 1995\f1'
.TP 16
.B gs_languagelevel
PostScript interpreter's language level (currently 1 or 2)
.P
According to Adobe's Document Structuring Conventions (DSC), all
resources needed by a document must be listed in document's prolog.
Since user's can create their own headers, \f3genscript\f1 don't know
what resources those headers use.  That's why all headers must contain
a standard DSC comment that lists all needed resources.  For example,
used fonts can be listed with following comment:

%%DocumentNeededResources: font \f2fontname1\f1 \f2fontname2\f1

Comment can be continued to the next line with the standard
continuation comment:

%%+ font \f2fontname3\f1

.SH SPECIAL ESCAPES

\f3Genscript\f1 supports special escape sequences that can be used to
add some page formatting commands to ASCII documents.  As a default,
special escapes interpretation is off, so all ASCII files print out as
anyone expects.  Special escapes interpretation is activated by giving
option \f3\-e\f1, \f3\-\-special\-escapes\f1 to \f3genscript\f1.

All special escapes start with the escape character ^@ (octal 000).
Escape character is followed by escape's name and optional options and
arguments.

Currently \f3genscript\f1 support following escapes:
.TP 8
.B epsf	
inline EPS file to the document.  Escape's syntax is:

^@epsf[\f2options\f1]{\f2filename\f1}

where \f2options\f1 is an optional sequence of option characters and
values enclosed with brackets and \f2filename\f1 is the name of the
EPS file.  

If \f2filename\f1 ends to the `|' character, then \f2filename\f1 is
assumed to name a command that prints EPS data to its standard output.
In this case, \f3genscript\f1 opens a pipe to the specified command
and reads EPS data from pipe.

Following options can be given to the \f3epsf\f1 escape:
.RS 8
.TP 8
.B c
print image centered
.TP 8
.B r
print image right justified
.TP 8
.B n
do not update current point.  Following output is printed to that
position where current point was just before the \f3epsf\f1 escape
.TP 8
.B nx
do not update current point \f2x\f1 coordinate
.TP 8
.B ny
do not update current point \f2y\f1 coordinate
.TP 8
.B x\f2num\f3
move image's top left \f2x\f1 coordinate \f2num\f1 characters from
current point \f2x\f1 coordinate (relative position)
.TP 8
.B x\f2num\f3a
set image's top left \f2x\f1 coordinate to column \f2num\f1 (absolute
position)
.TP 8
.B y\f2num\f3
move image's top left \f2y\f1 coordinate \f2num\f1 lines from current
line (relative position)
.TP 8
.B y\f2num\f3a
set image's top left \f2y\f1 coordinate to line \f2num\f1 (absolute
position)
.TP 8
.B h\f2num\f3
set image's height to \f2num\f1 lines
.TP 8
.B s\f2num\f3
scale image with factor \f2num\f1
.TP 8
.B sx\f2num\f3
scale image in \f2x\f1 direction with factor \f2num\f1
.TP 8
.B sy\f2num\f3
scale image in \f2y\f1 direction with factor \f2num\f1
.P
As a default, all dimensions are given in lines (vertical) and
characters (horizontal).  You can also specify other units by
appending an unit specifier after number.  

Possible unit specifiers and corresponding units are:
.TP 8
.B c
centimeters
.TP 8
.B i
inches
.TP 8
.B l
lines or characters (default)
.TP 8
.B p
PostScript points
.P
For example to print an image one inch high, you can specify height by
following options: \f3h1i\f1 (1 inch), \f3h2.54c\f1 (2.54 cm),
\f3h72p\f1 (72 points).
.RE
.TP 8
.B
font	
select current font.  Escape's syntax is:

^@epsf{\f2fontname\f1}

where \f2fontname\f1 is a standard font specification.  Font
specification is valid to the end of the current page; pagebreak
resets font to the default value.  Special font specification
\f3default\f1 can be used to select the default body font
(\f3genscript\f1's default or the one specified by the command line
option \f3\-f\f1, \f3\-\-font\f1).
.TP 8
.B
comment
comment the rest of the line including the newline character.
Escape's syntax is:

^@comment \f2text\f1 \f2newline_character\f1


.SH PAGE DEVICE OPTIONS

Page device is a PostScript level 2 feature that offers an uniform
interface to control printer's output device.  \f3Genscript\f1
protects all page device options inside an if block so they have no
effect in level 1 interpreters.  Although all level 2 interpreters
support page device, they do not have to support all page device
options.  For example some printers can print in duplex mode and some
can not.  Refer to the documentation of your printer for supported
options.

Here are some usable page device options which can be selected with
the \f3\-D\f1, \f3\-\-setpagedevice\f1 option.  For a complete listing,
see \f2PostScript Language Reference Manual\f1: section 4.11 Device
Setup. 
.TP 8
.B Collate \f2boolean\f1
how output is organized when printing multiple copies
.TP 8
.B Duplex \f2boolean\f1
duplex (two side) printing
.TP 8
.B ManualFeed \f2boolean\f1
manual feed paper tray
.TP 8
.B OutputFaceUp \f2boolean\f1
print output `face up' or `face down'
.TP 8
.B Tumble \f2boolean\f1
how opposite sides are positioned in duplex printing

.SH PRINTING EXAMPLES

Following printing examples assume that \f3genscript\f1 uses the
default configuration.  If default actions have been changed from the
configuration files, some examples will behave differently.
.TP 8
.B genscript foo.txt
Print file \f3foo.txt\f1 to the default printer.
.TP 8
.B genscript \-Possu foo.txt
Print file \f3foo.txt\f1 to printer \f3ossu\f1.
.TP 8
.B genscript \-pfoo.ps foo.txt
Print file \f3foo.txt\f1, but leave PostScript output to file
\f3foo.ps\f1.
.TP 8
.B genscript \-2 foo.txt
Print file \f3foo.txt\f1 to two columns.
.TP 8
.B genscript \-2r foo.txt
Print file to two columns and rotate output 90 degrees (landscape).
.TP 8
.B genscript \-DDuplex:true foo.txt
Print file in duplex (two side) mode (printer dependant).
.TP 8
.B genscript \-G2r foo.c
My default code printing command: Gaudy header, two columns,
landscape. 

.SH ENVIRONMENT VARIABLES

.nf
.ta 2.5i
GENSCRIPT		string containing default options
ENSCRIPT		string containing default options
.fi

For example, to select the default body font to be Times\-Roman 7pt,
set following value to the GENSCRIPT environment variable:
.TP 8
.B GENSCRIPT=\-fTimes\-Roman7
.P

Environment variables are processed before the command line options,
so command line options can be used to overwrite these defaults.

\f3Note!\f1 Variable ENSCRIPT is processed only to support backward
compatibility to the \f3enscript\f1 program.  It should not be used
otherwise.

.SH FILES

.nf
.ta 2.5i
\f2library\f1/*.hdr	header files
\f2library\f1/*.enc	input encoding vectors
\f2library\f1/*.eps	predefined EPS images
\f2library\f1/*.ps	genscript procsets
\f2library\f1/genscript.cfg	system\-wide configuration file
\f2library\f1/genscript.pro	PostScript prolog
\f2library\f1/afm/*.afm		AFM files for PostScript fonts
\f2library\f1/afm/font.map	directory for the AFM files
~/.genscriptrc		personal configuration file
~/.genscript/		personal resource directory
.fi

Where \f2library\f1 is \f3genscript\f1's library directory
(\f2installation prefix\f1/lib/genscript). 

.SH SEE ALSO
lpr(1), lpq(1), lprm(1), gs(1), ghostview(1)

.SH AUTHOR
Markku Rossi <mtr@iki.fi> <http://iki.fi/~mtr/>

Predefined EPS images by Jussi Hynninen <jhynnine@niksula.cs.hut.fi>
