/* 
 * String hash table.
 * Copyright (c) 1995 Markku Rossi.
 *
 * Author: Markku Rossi <mtr@iki.fi>
 */

/*
 * This file is part of the AFM library.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef STRHASH_H
#define STRHASH_H

typedef struct stringhash_st *StringHashPtr;

/*
 * Init a hash and return a hash handle or NULL if there were errors.
 */ 
StringHashPtr strhash_init (void);

/*
 * Free hash <hash>. Frees all resources that hash has allocated. <hash> 
 * shouldn't be used after this function is called.
 */
void strhash_free (StringHashPtr hash);

/*
 * Put key <key> to hash <hash>. <data> will be bind to <key>. Returns
 * true (1) if operation was successful or false (0) otherwise. If <key>
 * is already bind to another data, then <old_data> will be set to old
 * data. Otherwise it will be set to NULL.
 */
int strhash_put (StringHashPtr hash, char *key, int keylen, void *data,
		 void **old_data_return);

/*
 * Get data associated to key <key>. Data is returned in <*data>. 
 * Returns true (1) is key was found or false (0) otherwise.
 */
int strhash_get (StringHashPtr hash, const char *key, int keylen,
		 void **data_return);

/*
 * Deletes key <key> form <hash>. Data is returned in <*data>. Returns
 * true (1) if <key> was found or false (0) if <key> was not found or
 * errors were encountered.
 */
int strhash_delete (StringHashPtr hash, const char *key, int keylen,
		    void **data_return);

/*
 * Get first item from hash <hash>.  Returns 1 if there were items
 * or 0 otherwise.
 */
int strhash_get_first (StringHashPtr hash, char **key_return,
		       int *keylen_return, void **data_return);

/*
 * Get next item from hash <hash>.  Returns 1 if there were items
 * or 0 otherwise.
 */
int strhash_get_next (StringHashPtr hash, char **key_return,
		      int *keylen_return, void **data_return);

#endif /* not STRHASH_H */
