/*
 *	TABLES.C  --    this C file contains initializing declarations
 *			for variables used by the IP/TCP/POP2 server.
 *
 *      (C) Copyright 1991 Regents of the University of California
 *
 *      Permission to use, copy, modify, and distribute this program
 *      for any purpose and without fee is hereby granted, provided
 *      that this copyright and permission notice appear on all copies
 *      and supporting documentation, the name of University of California
 *      not be used in advertising or publicity pertaining to distribution
 *      of the program without specific prior permission, and notice be
 *      given in supporting documentation that copying and distribution is
 *      by permission of the University of California.
 *      The University of California makes no representations about
 *      the suitability of this software for any purpose.  It is provided
 *      "as is" without express or implied warranty.
 *
 *	REVISIONS:
 *			12-87	[ks]	original implementation
 *		1.000	 5-88	[ks]
 *		1.001	 2-89	[ks]
 *
 */

#include "globdefs.h"
#include "svrdefs.h"

char 	flash_buf[CMD_BUFSIZ+1];		/* Very temp storage */

char 	*host_client	= NULL;			/* Non-NULL when HOST folder */
char	*smtp_host	= NULL;			/* HELO host from BSMTP file */

int	fld_cnt		= 0;			/* # msgs currently loaded */
int	svr_state	= SVR_LSTN_STATE;	/* Current state of server */

char	*svr_input[]	= {			/* Possible client commands */
    "open",
    "HELO",
    "FOLD",
    "HOST",
    "READ",
    "RETR",
    "ACKS",
    "ACKD",
    "NACK",
    "QUIT",
    NULL
};

						/* Server decision table */
int	 svr_table[SVR_MAXVERBS][SVR_MAXSTATES] = {
    {	1,0,0,0,0,0   },			/* Client: open */
    {	0,2,0,0,0,0   },			/* Client: HELO */
    {	0,0,4,4,0,0   },			/* Client: FOLD */
    {   0,0,9,9,0,0   },			/* Client: HOST */
    {	0,0,5,5,0,0   },			/* Client: READ */
    {	0,0,0,6,0,0   },			/* Client: RETR */
    {	0,0,0,0,7,0   },			/* Client: ACKS */
    {	0,0,0,0,7,0   },			/* Client: ACKD */
    {	0,0,0,0,7,0   },			/* Client: NACK */
    {	3,3,3,3,3,0   },			/* Client: QUIT */
    {   0,0,0,0,0,0   }				/* Client: other */
};
