#! /bin/sh
#
#                             COPYRIGHT
# 
#   PCB, interactive printed circuit board design
#   Copyright (C) 1994 Thomas Nau
# 
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
# 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
#   Contact addresses for paper mail and Email:
#   Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
#   Thomas.Nau@medizin.uni-ulm.de
# 
#   RCS: $Header: create_sed_script.sh,v 1.2 94/07/19 14:37:35 nau Exp $
#
#
# create a sed script used to create the application default resource file
# and the man pages
# Usage: create_sed_script.sh [imake defines]
#

# some system need nawk
#
case `uname` in
	SunOS)	AWK=nawk;;
	*)		AWK=awk;;
esac

# extract defines passed from Makefile and create sed script
#
while [ $# -gt 0 ]
do
	echo $1 | \
	sed -e '/\//s//\\\//g' \
		-e '/^-D\([A-Za-z0-9_]*\)=\(.*\)/s//\/\1\/s\/\/\2\/g/g' \
		-e '/^[^/]/d' \
		-e '/"/s///g'
	shift
done

# get defines from global.h and add them to script
#
grep '^#define' global.h | \
$AWK '
	function shift(n) {
		f = 1;
		for (i = 0; i < n; i++)
			f *= 2;
		return(f);
	}
	/MAX_ZOOM/	{ printf("/MAX_ZOOM_NUMBER/s//%d/g\n", shift($3)); next; }
	/MIN_ZOOM/	{ printf("/MIN_ZOOM_NUMBER/s//%d/g\n", shift($3)); next; }
				{ printf("/%s/s//%s/g\n", $2, $3); next; }
	'

