/* util.h
 $Header: /al/acs/src/RCS/util.h,v 9.28 95/11/04 15:32:44 al Exp $
 * inline utility functions, general purpose
 * some are workarounds for common compiler or system wierdness
 */
#ifndef UTIL_H
#define UTIL_H
#include "md.h"
/*--------------------------------------------------------------------------*/
inline double max(double x, double y)
   {return (x>y) ? x : y;}
inline int max(int x, int y)
   {return (x>y) ? x : y;}

inline double min(double x, double y)
   {return (x<y) ? x : y;}
inline int min(int x, int y)
   {return (x<y) ? x : y;}

inline int uporder(double a, double b, double c)
   {return (a<=b) && (b<=c);}

inline int inorder(double a, double b, double c)
   {return uporder(a,b,c) || uporder(c,b,a);}

inline double torange(double a, double b, double c)
   {return min(max(a,b),c);}

inline char to_upper(char c)
   {return ((islower(c))?toupper(c):c);}

inline char to_lower(char c)
   {return ((isupper(c))?tolower(c):c);}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
