/* e_elem2.cc
 *$Header: /al/acs/src/RCS/e_elem2.cc,v 9.22 95/10/22 02:54:03 al Exp $
 * Base class for elements of a circuit
 */
#include "ap.h"
#include "error.h"
#include "e_elemnt.h"
#include "u_opt.h"
#include "u_status.h"
#include "io.h"
#include "s__.h"
#include "util.h"
/*--------------------------------------------------------------------------*/
//	void	ELEMENT::parse(CS&);
//	void	ELEMENT::print(int,int)const;
//	void	ELEMENT::trsetup();
//	int	ELEMENT::conv_check()const;
/*--------------------------------------------------------------------------*/
void ELEMENT::parse(CS& cmd)
{
  parselabel(cmd);
  parsenodes(cmd,DEFAULT_NUMNODES);
  parseexpr(cmd);
}
/*--------------------------------------------------------------------------*/
void ELEMENT::print(int where, int detail)const
{
  printlabel(where);
  printnodes(where,DEFAULT_NUMNODES);
  printexpr(where);
  mputc('\n', where);
}
/*--------------------------------------------------------------------------*/
/* trsetup: set up guesses for model evaluation
 * saves old model inputs, and computes new inputs (volts and current)
 * also saves old matrix parameters, for convergence checking
 */
void ELEMENT::trsetup()
{
  y2 = y1;
  y1 = y0;
  if (SIM::mode == sDC  ||  SIM::phase == pINIT_DC){	// initial dc
  }else if (time0 != SIM::time0){	// new time step
    time0 = SIM::time0;
  }
}
/*--------------------------------------------------------------------------*/
/* conv_check: check branch for convergence
 * should be a macro for speed
 */
int ELEMENT::conv_check()const
{
  int isconverged = conchk(y1.f0,y0.f0,OPT::abstol);
  if ((STATUS::iter[iSTEP] >= OPT::itl[OPT::TRACE]) && !isconverged){
    error(bPICKY,"%s: non-convergence: (f0) (%s,%s,%s)\n",
          printlabel(),
          ftos(y0.f0, "", 7, 0),
          ftos(y1.f0, "", 7, 0),
          ftos(y2.f0, "", 7, 0));
    if (!conchk(y1.f1,y0.f1,OPT::abstol)){
      error(bPICKY,"%s: non-convergence: (f1) (%s,%s,%s)\n",
	    printlabel(),
	    ftos(y0.f1, "", 7, 0),
	    ftos(y1.f1, "", 7, 0),
	    ftos(y2.f1, "", 7, 0));
    }else{
      error(bPICKY,"%s: f1 is ok\n", printlabel());
    }
  }

  if (isconverged){
    isconverged = conchk(y1.f1,y0.f1,OPT::abstol);
    if ((STATUS::iter[iSTEP] >= OPT::itl[OPT::TRACE]) && !isconverged){
      error(bPICKY,"%s: non-convergence: (f1 only) (%s,%s,%s)\n",
	    printlabel(),
	    ftos(y0.f1, "", 7, 0),
	    ftos(y1.f1, "", 7, 0),
	    ftos(y2.f1, "", 7, 0));
    }
  }
  return isconverged;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
