/* d_mos2.cc
 *$Header: /al/acs/src/RCS/d_mos2.cc,v 9.28 95/11/04 15:31:11 al Exp $
 * mos model equations: spice level 2 equivalent
 */
#include "d_mos.h"
#include "error.h"
#include "io.h"
#include "s__.h"
#include "u_opt.h"
#include "util.h"
/*--------------------------------------------------------------------------*/
//	void	DEV_MOS::eval_mos2(CARD*);
/*--------------------------------------------------------------------------*/
#define short_channel	(m->xj != NOT_INPUT  &&  m->xj > 0.)
#define do_subthreshold	(m->nfs != 0.)
/*--------------------------------------------------------------------------*/
/*static*/ void DEV_MOS::eval_mos2(CARD *brh)
{
  DEV_MOS* This = (DEV_MOS*)brh;
  assert(This);
  const MOS_COMMON* cc = (const MOS_COMMON*)This->common;
  assert(cc);
  const MODEL_MOS* m = (const MODEL_MOS*)cc->model;
  assert(m);
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  //error(bTRACE,"%s:%d: vds=%e vgs=%e vbs=%e\n",
  //	This->printlabel(), This->evaliter, This->vds, This->vgs, This->vbs);
  double v_phi_s = m->phi - This->vbs;
  double sarg, dsarg_dvbs, d2sdb2, sarg3;
  {
    if (This->vbs <= 0.){
      sarg = sqrt(v_phi_s);
      dsarg_dvbs = -.5 / sarg;
      d2sdb2 = .5 * dsarg_dvbs / v_phi_s;
      This->sbfwd = FALSE;
    }else{
      double sphi3 = pow(m->phi, 1.5);
      if (OPT::mosflags & 01000){
	sarg = sqrt(m->phi) / (1. + .5 * This->vbs / m->phi);
	dsarg_dvbs = -.5 * sarg * sarg / sphi3;
	d2sdb2 = -dsarg_dvbs * sarg / sphi3;
      }else{
	sarg = sqrt(m->phi) 
	    / (1. + .5 * This->vbs / m->phi 
	    	  + .375 * This->vbs * This->vbs / (m->phi * m->phi));
	dsarg_dvbs = (-.5 * sarg * sarg / sphi3) 
		* (1. + 1.5 * This->vbs / m->phi);
	d2sdb2 = (-dsarg_dvbs * sarg / sphi3)
		- (.75 * sarg / (sphi3 * m->phi)) 
			* (2. * This->vbs * dsarg_dvbs + sarg);
      }
      This->sbfwd = TRUE;
      if (!IO::suppresserrors){
	error((This->vbs > m->phi) ? bPICKY : bTRACE,
	      "%s: source fwd biased. vbs=%g\n", This->printlabel(), This->vbs);
      }
    }
    sarg3 = sarg*sarg*sarg;
    assert(sarg > 0.);
    assert(dsarg_dvbs < 0.);
    assert(uporder(-1/m->phi, d2sdb2, 1/m->phi));
    //error(bTRACE, "v_phi_s=%e sarg=%e dsarg_dvbs=%e\n",
    //		   v_phi_s,   sarg,   dsarg_dvbs);
    //error(bTRACE, "d2sdb2=%e sarg3=%e\n",
    //		   d2sdb2,   sarg3);
  }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  double barg, dbarg_dvbs, d2bdb2;
  {
    double vbd = This->vbs - This->vds;
    double v_phi_d = m->phi - vbd;
    if (vbd <= 0.){
      barg = sqrt(v_phi_d);
      dbarg_dvbs = -.5 / barg;
      d2bdb2 = .5 * dbarg_dvbs / v_phi_d;
      This->dbfwd = FALSE;
    }else{
      double sphi3 = pow(m->phi, 1.5);
      if (OPT::mosflags & 01000){
	barg = sqrt(m->phi) / (1. + .5 * vbd / m->phi);
	dbarg_dvbs = -.5 * barg * barg / sphi3;
	d2bdb2 = -dbarg_dvbs * barg / sphi3;
      }else{
	barg = sqrt(m->phi) 
	    / (1. + .5 * vbd / m->phi 
	    	  + .375 * vbd * vbd / (m->phi * m->phi));
	dbarg_dvbs = (-.5 * barg * barg / sphi3) 
		* (1. + 1.5 * vbd / m->phi);
	d2bdb2 = (-dbarg_dvbs * barg / sphi3)
		- (.75 * barg / (sphi3 * m->phi)) 
			* (2. * vbd * dbarg_dvbs + barg);
      }
      This->dbfwd = TRUE;
      if (!IO::suppresserrors){
	error((vbd > m->phi) ? bPICKY : bTRACE,
		  "%s: drain fwd biased. vbd=%g\n",
		  This->printlabel(),  This->vbs - This->vds);
      }
    }
    assert(barg > 0.);
    assert(dbarg_dvbs < 0.);
    assert(uporder(-1/m->phi, d2bdb2, 1/m->phi));
    //error(bTRACE, "barg=%e dbarg_dvbs=%e d2bdb2=%e\n",
    //		   barg,   dbarg_dvbs,   d2bdb2);
  }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  double gamma_s, dgamma_s_dvds, dgamma_s_dvbs, dgddb2;
  {
    if (short_channel){
      double wd = m->xd * barg;
      double argxd = 1. + 2. * wd / m->xj;
        assert(argxd > 0);
      double argd = sqrt(argxd);
      double alpha_d = cc->relxj * (argd - 1.);
      double dalpha_d_dvds = m->xd / (4. * cc->le * argd * barg);
      double dalpha_d_dvbs = -dalpha_d_dvds;
      
      double ws = m->xd * sarg;
      double argxs = 1. + 2. * ws / m->xj;
        assert(argxs > 0);
      double args = sqrt(argxs);
      double alpha_s = cc->relxj * (args - 1.);
      double dalpha_s_dvbs = -m->xd / (4. * cc->le * args * sarg);
      
      gamma_s = m->gamma * (1. - alpha_s - alpha_d);
      dgamma_s_dvds = -m->gamma *  dalpha_d_dvds;
      dgamma_s_dvbs = -m->gamma * (dalpha_d_dvbs + dalpha_s_dvbs);
  
      double dasdb2 = -m->xd*(d2sdb2+dsarg_dvbs*dsarg_dvbs*m->xd/(m->xj*argxs))
	  / (cc->le*args);
      double daddb2 = -m->xd*(d2bdb2+dbarg_dvbs*dbarg_dvbs*m->xd/(m->xj*argxd))
	  / (cc->le*argd);
      dgddb2 = -.5 * m->gamma * (dasdb2 + daddb2);
  
      if (gamma_s <= 0. && m->gamma > 0. /* && !IO::suppresserrors */){
	error(bTRACE, "%s: gamma is negative\n", This->printlabel());
	error(bTRACE, "+   gamma_s=%g, alpha_s=%g, alpha_d=%g\n",
	      gamma_s,    alpha_s,    alpha_d);
      }
    }else{
      gamma_s = m->gamma;
      dgamma_s_dvds = dgamma_s_dvbs = 0.;
      dgddb2 = 0.;
    }
    //error(bTRACE, "gamma_s=%e dgamma_s_dvds=%e\n",
    //	       	   gamma_s,   dgamma_s_dvds);
    //error(bTRACE, "dgamma_s_dvds=%e dgddb2=%e\n",
    //		   dgamma_s_dvds,   dgddb2);
  }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  /* von, subthreshold, cutoff, vgst */
  double vt = (K/Q) * SIM::temp;
  double vc, vc_eta;
  double dodvbs;
  double xn = 0.;
  double vtxn = 0.;
  double dxndvb = 0.;	/* subthreshold only */
  {
    double vbin = m->vbi + cc->eta_1 * v_phi_s;
    This->von = vbin + gamma_s * sarg;
    
    dodvbs = -cc->eta_1 + dgamma_s_dvbs * sarg + gamma_s * dsarg_dvbs;
    if (do_subthreshold){
      double cdonco = -(gamma_s*dsarg_dvbs + dgamma_s_dvbs*sarg) + cc->eta_1;
      dxndvb = 2. * dgamma_s_dvbs * dsarg_dvbs
			+ gamma_s * d2sdb2 + dgddb2 * sarg;
      dodvbs += vt * dxndvb;
      xn = 1. + m->cfsox + cdonco;
      vtxn = vt * xn;
      This->von += vtxn;
      This->subthreshold = (This->vgs < This->von);
      This->cutoff = FALSE;
      //error(bTRACE, "cdonco=%e\n", cdonco);
    }else if (This->vgs < This->von){
      This->cutoff = TRUE;
      This->subthreshold = FALSE;
      This->ids = 0.;
      This->gm = 0.;
      This->gds = 0.;
      This->gmb = 0.;
      This->vgst = This->vgs - This->von;
      //error(bTRACE, "cutoff shortcut von=%e vgst=%e\n",
      //	This->von, This->vgst);
      return;					/* quick exit if cutoff */
    }else{
      This->cutoff = FALSE;
      This->subthreshold = FALSE;
    }
    double vgsx = (This->subthreshold) ? This->von : This->vgs;
    vc = vgsx - vbin;
    vc_eta = vc / cc->eta;
    This->vgst = This->vgs - This->von;
    //error(bTRACE, "von=%e subthreshold=%d cutoff=%d vgst=%e\n",
    //		This->von, This->subthreshold, This->cutoff, This->vgst);
    //error(bTRACE, "vbin=%e vt=%e vc=%e vc_eta=%e\n",
    //		   vbin,   vt,   vc,   vc_eta);
    //error(bTRACE, "dodvbs=%e xn=%e vtxn=%e dxndvb=%e\n",
    //		   dodvbs,   xn,   vtxn,   dxndvb);
  }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  double ufact, dudvgs, dudvds, dudvbs;
  {
    if (m->uexp != NOT_INPUT  &&  This->vgst > m->vbp){
      ufact = pow(m->vbp/This->vgst, m->uexp);
      dudvgs = -ufact * m->uexp / This->vgst;
      dudvds = 0.;	/* wrong, but as per spice2 */
      dudvbs = dodvbs * ufact * m->uexp / This->vgst;
    }else{
      ufact = 1.;
      dudvgs = dudvds = dudvbs = 0.;
    }
    //error(bTRACE, "ufact=%e dudvgs=%e dudvds=%e dudvbs=%e\n",
    //		   ufact,   dudvgs,   dudvds,   dudvbs);
  }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  /* vdsat  according to Baum's Theory of scattering velocity saturation  */
  int use_vmax = m->vmax != NOT_INPUT;
  double ueff = 0.;
  if (use_vmax){
    double y3;
    double xvalid = 0.;
    double x4[8];
    double gammad = gamma_s / cc->eta;
    ueff = m->uo * ufact;	/* ???? */
    double v1 = vc_eta + v_phi_s;
    double v2 = v_phi_s;
    double xv = m->vmax * cc->le / ueff;
    double a1 = gammad * (4./3.);
    double b1 = -2. * (v1+xv);
    double c1 = -2. * gammad * xv;			/* end of scope */
    double d1 = 2.*v1*(v2+xv) - v2*v2 - (4./3.)*gammad*sarg3;
    double a = -b1;					/* xv, v1, v2, sarg3 */
    double b = a1 * c1 - 4. * d1;
    double c = -d1 * (a1*a1 - 4.*b1) - c1*c1;
    double r = -a*a / 3. + b;
    double r3 = r*r*r;					/* r */
    double s = 2. * a*a*a / 27. - a*b / 3. + c;		/* b, c */
    double s2 = s*s;
    double p = s2 / 4. + r3 / 27.;			/* r */
    if (p < 0.){					/* p */
      double ro = pow((-r3 / 27), (1./6.));		/* s2, r3 */
      double fi = atan(-2. * sqrt(-p) / s);
      y3 = 2. * ro * cos(fi/3.) - a / 3.;
    }else{
      double p2 = sqrt(p);
      double p3 = pow((fabs(-s/2.+p2)), (1./3.));
      double p4 = pow((fabs(-s/2.-p2)), (1./3.));	/* s */
      y3 = p3 + p4 - a / 3.;				/* a */
    }

    int iknt = 0;
    if (a1*a1 / 4. - b1 + y3  < 0.  &&  y3*y3 / 4. - d1  < 0.){
      error(bWARNING,
	    "%s: internal error: a3,b4, a1=%g, b1=%g, y3=%g, d1=%g\n",
	    This->printlabel(),	      a1,    b1,    y3,    d1);
    }else{
      double a3 = sqrt(a1*a1 / 4. - b1 + y3);
      double b3 = sqrt(y3*y3 / 4. - d1);
      int i;
      for (i = 0;   i < 4;   i++){
	static const double sig1[4] = {1., -1., 1., -1.};
	static const double sig2[4] = {1., 1., -1., -1.};
	double a4 = a1 / 2. + sig1[i] * a3;
	double b4 = y3 / 2. + sig2[i] * b3;		/* y3 */
	double delta4 = a4*a4 / 4. - b4;
	if (delta4 >= 0.){
	  x4[iknt++] = - a4 / 2. + sqrt(delta4);
	  x4[iknt++] = - a4 / 2. - sqrt(delta4);	/* i */
	}
      }
    }

    int root_count = 0;
    int j;
    for (j = 0;   j < iknt;   j++){			/* iknt */
      if (x4[j] > 0.){
	double poly4 = x4[j]*x4[j]*x4[j]*x4[j]	/* ~= 0, used as check	*/
	  	+ a1 * x4[j]*x4[j]*x4[j]	/* roundoff error not	*/
	 	+ b1 * x4[j]*x4[j]		/* propagated, so ok	*/
		+ c1 * x4[j]
		+ d1;				/* a1, b1, c1, d1 */
	if (fabs(poly4) <= 1e-6){
	  root_count++;
	  if (root_count <= 1)			/* xvalid = min(x4[j]) */
	    xvalid=x4[j];
	  if (x4[j] <= xvalid)
	    xvalid=x4[j];				/* x4[], j */
	}
      }
    }
    if (root_count <= 0){				/* root_count */
      if (OPT::picky <= bTRACE || !IO::suppresserrors)
	error(bWARNING, "%s: Baum's theory rejected\n", This->printlabel());
      use_vmax = FALSE;
      This->vdsat = 0.;
    }else{
      This->vdsat = xvalid*xvalid - v_phi_s;
    }
    //error(bTRACE, "use_vmax ueff=%e vdsat=%e\n",
    //			    ueff, This->vdsat);
  }else{
    This->vdsat = 0.;
    //error(bTRACE, "!use_vmax ueff=%e vdsat=%e\n",
    //			     ueff, This->vdsat);
  }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  /* vdsat     according to Grove-Frohman equation  */
  double dvdsat_dvgs = 0.;	/* deferred if use_vmax */
  double dvdsat_dvbs = 0.;
  if (!use_vmax){
    if (gamma_s > 0.){
      double argv = vc_eta + v_phi_s;
      if (argv > 0.){
	double gammad = gamma_s / cc->eta;
	double gammd2 = gammad * gammad;
	double arg = sqrt(1. + 4. * argv / gammd2);
	This->vdsat = vc_eta  +  gammd2 * (1.-arg) / 2.;
	dvdsat_dvgs = (1. - 1./arg) / cc->eta;
	dvdsat_dvbs = (gammad * (1.-arg) + 2.*argv / (gammad*arg))
	  / cc->eta * dgamma_s_dvbs
	    + 1./arg + cc->eta_1 * dvdsat_dvgs;
      }else{
	This->vdsat = 0.;
	dvdsat_dvgs = dvdsat_dvbs = 0.;
	if (!IO::suppresserrors){
	  error(bWARNING, "%s: argv is negative\n", This->printlabel());
	  error(bTRACE  , "+   vc=%g, argv=%g, vdsat=%g\n",
			       vc,    argv,    This->vdsat);
	  error(bTRACE  , "+   vds=%g, vgs=%g, vbs=%g\n",
			  This->vds, This->vgs, This->vbs);
	}
      }
    }else{
      This->vdsat = vc_eta;
      dvdsat_dvgs = 1.;
      dvdsat_dvbs = 0.;
    }
    //error(bTRACE, "!use_vmax vdsat=%e dvdsat_dvgs=%e dvdsat_dvbs=%e\n",
    //		       This->vdsat,   dvdsat_dvgs,   dvdsat_dvbs);
  }else{
    //error(bTRACE, "use_vmax vdsat=%e dvdsat_dvgs=%e dvdsat_dvbs=%e\n",
    //		      This->vdsat,   dvdsat_dvgs,   dvdsat_dvbs);
  }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  if (This->vdsat < 0.){
    error(bWARNING, "%s: calculated vdsat (%g) < 0.  using vdsat = 0.\n",
	  This->printlabel(), This->vdsat);
    This->vdsat = 0.;
  }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  double bsarg, dbsarg_dvbs;
  {
    double vbdsat = This->vbs - This->vdsat;
    if (vbdsat <= 0.){
      double v_phi_ds = m->phi - vbdsat;
      bsarg = sqrt(v_phi_ds);
      dbsarg_dvbs = -.5 / bsarg;
    }else{
      double sphi3 = pow(m->phi, 1.5);
      bsarg = sqrt(m->phi) / (1. + .5 * vbdsat / m->phi);
      dbsarg_dvbs = -.5 * bsarg * bsarg / sphi3;
    }
    //error(bTRACE, "vbdsat=%e bsarg=%e dbsarg_dvbs=%e\n",
    //		   vbdsat,   bsarg,   dbsarg_dvbs);
  }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  /* local   dvdsat_dvgs, dvdsat_dvbs   maybe */
  if (use_vmax){
    double bodys = bsarg*bsarg*bsarg - sarg3;
    double gdbdvs =
      2. * gamma_s * (bsarg*bsarg*dbsarg_dvbs - sarg*sarg*dsarg_dvbs);
    double argv = vc_eta - This->vdsat;
    double vqchan = argv - gamma_s * bsarg;
    double dqdsat = -1. + gamma_s * dbsarg_dvbs;
    double vl = m->vmax * cc->le;
    double dfunds = vl * dqdsat - ueff * vqchan;
    double dfundg = (vl - ueff * This->vdsat) / cc->eta;
    double dfundb = -vl * (1. + dqdsat - cc->eta_1 / cc->eta)
      + ueff * (gdbdvs - dgamma_s_dvbs * bodys / 1.5) / cc->eta;
    dvdsat_dvgs = -dfundg / dfunds;
    dvdsat_dvbs = -dfundb / dfunds;
    //error(bTRACE, "use_vmax dvdsat_dvgs=%e dvdsat_dvbs=%e\n",
    //			    dvdsat_dvgs,   dvdsat_dvbs);
  }else{
    //error(bTRACE, "!use_vmax dvdsat_dvgs=%e dvdsat_dvbs=%e\n",
    //			     dvdsat_dvgs,   dvdsat_dvbs);
  }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  double  dldvgs, dldvds, dldvbs, clfact;
  {
    if (This->vds > 0.){
      if (m->lambda == NOT_INPUT){
	double dldsat;
	if (use_vmax){
	  double xdv = m->xd / sqrt(m->neff);
	  double xlv = m->vmax * xdv / (2. * ueff);
	  double argv = This->vds - This->vdsat;
	  if (argv < 0.)
	    argv = 0.;
	  double xls = sqrt(xlv*xlv + argv);
	  double dl = (xls-xlv) * xdv;
	  /* lambda = dl / (cc->le * This->vds); */
	  clfact = (1. - dl / cc->le);
	  dldsat = xdv / (2. * xls * cc->le);
	}else{
	  double argv = (This->vds - This->vdsat) / 4.;
	  double sargv = sqrt(1. + argv*argv);
	  if (argv + sargv >= 0.){
	    double dl = m->xd * sqrt(argv + sargv);
	    /* lambda = dl / (cc->le * This->vds); */
	    clfact = (1. - dl / cc->le);
	    /* dldsat = lambda * This->vds / (8. * sargv); */
	    dldsat = dl / (cc->le * 8. * sargv);
	  }else{
	    /* lambda = 0.; */
	    clfact = 1.;
	    dldsat = 0.;
	    error(bWARNING, "%s: internal error: vds(%g) < vdsat(%g)\n",
		  This->printlabel(), This->vds,   This->vdsat);
	  }
	}
	dldvgs =  dvdsat_dvgs * dldsat;
	dldvds =              - dldsat;
	dldvbs =  dvdsat_dvbs * dldsat;
      }else{
	/* lambda = m->lambda; */
	clfact = (1. - m->lambda * This->vds);
	dldvgs = dldvbs = 0.;
	dldvds = -m->lambda;
      }
    
      /* clfact = (1. - lambda * This->vds); */
      if (clfact < m->xwb/cc->le){
	double leff = m->xwb / (2. - (clfact * cc->le / m->xwb));
	double dfact = (leff * leff) / (m->xwb * m->xwb);
	clfact = leff / cc->le;
	dldvgs *= dfact;
	dldvds *= dfact;
	dldvbs *= dfact;
      }
    }else{  /* vds <= 0. */
      /* lambda = 0.; */
      clfact = 1.;
      dldvgs = dldvds = dldvbs = 0.;
    }
    //error(bTRACE,"vds=%e lambda=%e dldvgs=%e dldvds=%e dldvbs=%e clfact=%e\n",
    //	     This->vds, m->lambda,  dldvgs,   dldvds,   dldvbs,   clfact);
  }
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/ 
  /* ids, gm, gds, gmb */
  {
    This->saturated = (This->vds > This->vdsat);
    double vdsx =  (This->saturated) ? This->vdsat : This->vds;
    double bargx = (This->saturated) ? bsarg : barg;
    double body = bargx*bargx*bargx - sarg3;
    double expg = (This->subthreshold) ? Exp(This->vgst / vtxn) : 1.;
    double beta = cc->beta * ufact / clfact;
        
    double ids_on = 
	  beta * ((vc - cc->eta_2 * vdsx) * vdsx  - (2./3.) * gamma_s * body);
    double didvds = beta * (vc  -  cc->eta * vdsx  -  gamma_s * bargx);

    //error(bTRACE, "vdsx=%e bargx=%e body=%e expg=%e\n",
    //		   vdsx,   bargx,   body,   expg);
    //error(bTRACE, "beta=%e ids_on=%e didvds=%e saturated=%d\n",
    //		   beta,   ids_on,   didvds, This->saturated);

    if (ids_on < -OPT::abstol){
      error(bTRACE,"%s:%d: ids_on=%g\n",
		This->printlabel(), This->evaliter, ids_on);
    }
    This->ids = ids_on * expg;
    
    This->gm = beta * vdsx;
    This->gm += ids_on * (dudvgs/ufact - dldvgs/clfact);
    if (This->saturated)
      This->gm += didvds * dvdsat_dvgs;
    if (This->subthreshold){
      This->gm = ids_on / vtxn;
      if (This->saturated)
	This->gm += didvds * dvdsat_dvgs;
      This->gm *= expg;
    }
    
    This->gds = (This->saturated) ? 0.: didvds;
    This->gds += ids_on * (dudvds/ufact - dldvds/clfact);
    if (short_channel)
      This->gds -= beta * (2./3.) * body * dgamma_s_dvds;
    if (This->subthreshold){
      double dxndvd = dgamma_s_dvds * dsarg_dvbs;
      double dodvds = dgamma_s_dvds * sarg + vt * dxndvd;
      double gmw = This->ids * This->vgst / (vtxn * xn);
      This->gds *= expg;
      This->gds -= This->gm * dodvds + gmw * dxndvd;
    }

    This->gmb = beta * (cc->eta_1 * vdsx - gamma_s * (sarg - bargx));
    This->gmb += ids_on * (dudvbs/ufact - dldvbs/clfact);
    if (short_channel)
      This->gmb -= beta * (2./3.) * body * dgamma_s_dvbs;
    if (This->saturated)
      This->gmb += didvds * dvdsat_dvbs;
    if (This->subthreshold){
      double gmw = This->ids * This->vgst / (vtxn * xn);
      This->gmb += beta * dodvbs * vdsx;
      This->gmb *= expg;
      This->gmb -= This->gm * dodvbs + gmw * dxndvb;
    }
    //error(bTRACE, "ids=%e gm=%e gds=%e gmb=%e\n",
    //	 This->ids, This->gm, This->gds, This->gmb);
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
