/*	
 *   xtel - Emulateur MINITEL sous X11
 *
 *   Copyright (C) 1991-1994  Lectra Systemes & Pierre Ficheux
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ident "$Id: global.h,v 1.5 1995/07/24 13:43:57 pierre Exp $"

#ifndef _global_h
#define _global_h

#ifndef EXTERN
#define EXTERN
#endif 

/* 
 * Fonctions 
 */

#ifdef __STDC__

/* xtel.c */
void init_xtel(void);
void sauve_l_ecran(Widget w, XEvent *pevent, String  *params, Cardinal nb_params);
int main(int argc, char **argv);
/* ligne.c */
void ce_n_est_qu_un_au_revoir(void);
void fonction_lecture_ligne(XtPointer client_data, int *fid, XtInputId *id);
void connexion_service(char *service);
/* bouton.c */
void evenement_entre_widget(Widget w, char *client_data, XEvent *pevent);
void commandes(Widget w, char *code, XtPointer call_data);
char *xtel_basename(char *s);
void Charge(void);
void Sauve(void);
void composition_valide(int flag);
void clavier_minitel_valide(int flag);
void mise_a_jour_mode_emulation(int flag_invalide);
void raccrocher (Widget w, char *code, XtPointer call_data);
/* inet.c */
int c_clientbyname(char *host, char *name);
/* imprime.c */
void imprime_page_courante(void);
/* lecteur.c */
void stop_rapide(void);
void fonction_lecture_fichier_courant(XtPointer client_data, int *fid, XtInputId *id);
void fin_lecteur(Widget w, XtPointer client_data, XtPointer call_data);
void Play_lecteur(Widget w, XtPointer client_data, XtPointer call_data);
void Stop_lecteur(Widget w, XtPointer client_data, XtPointer call_data);
void Zero_lecteur(Widget w, XtPointer client_data, XtPointer call_data);
void Rewind_lecteur(Widget w, XtPointer client_data, XtPointer call_data);
void Wind_lecteur(Widget w, XtPointer client_data, XtPointer call_data);
void raz_lecteur(void);
void debut_lecteur(void);
/* procedure.c */
int init_procedures(void);
/* teleinfo.c */
void teleinfo(char *nom);
char conversion_teleinfo_fr(int car);
void fonction_lecture_teleinfo(XtPointer client_data, int *fid, XtInputId *id);
void zigouille_xterm_teleinfo(void);
void selection_mode_emulation(Widget w, char *mode, XtPointer call_data);
/* copyright.c */
int affiche_copyright(Widget w, WidgetClass classe_forme, Pixmap pixmap);
/* xm.c/xaw.c */
Widget init_toolkit(int *pargc, char **argv);
Widget init_widgets(Widget topLevel);
void affiche_erreur(char *s, int code_erreur);
void lecteur_valide(int flag);
void efface_lecteur(void);
void affiche_lecteur(void);
void affiche_compteur_lecteur_caractere(void);
void affiche_compteur_lecteur_page(void);
void activation_bouton_stop(void);

#else

void init_xtel();
void sauve_l_ecran();
int main();
void ce_n_est_qu_un_au_revoir();
void fonction_lecture_ligne();
void connexion_service();
void evenement_entre_widget();
void commandes();
char *xtel_basename();
void Charge();
void Sauve();
void composition_valide();
void clavier_minitel_valide();
void mise_a_jour_mode_emulation();
void raccrocher();
int c_clientbyname();
void imprime_page_courante();
void stop_rapide();
void fonction_lecture_fichier_courant();
void fin_lecteur();
void Play_lecteur();
void Stop_lecteur();
void Zero_lecteur();
void Rewind_lecteur();
void Wind_lecteur();
void raz_lecteur();
void debut_lecteur();
int init_procedures();
void teleinfo();
char conversion_teleinfo_fr();
void fonction_lecture_teleinfo();
void zigouille_xterm_teleinfo();
void selection_mode_emulation();
int affiche_copyright();
Widget init_toolkit();
Widget init_widgets();
void affiche_erreur();
void lecteur_valide();
void efface_lecteur();
void affiche_lecteur();
void affiche_compteur_lecteur_caractere();
void affiche_compteur_lecteur_page();
void activation_bouton_stop();

#endif /* __STDC__ */

/* 
 * Variables 
 */
#ifndef __FreeBSD__
extern char *sys_errlist[];
#endif

/* xtel.c */
#ifdef NO_NETWORK
EXTERN struct sockaddr_un unaddr;
#endif /* NO_NETWORK */
EXTERN Widget ecran_minitel;		/* Widget Videotex */
EXTERN unsigned int  cpt_buffer;	/* nb de caracteres courant */
EXTERN char flag_enregistrement;
EXTERN char flag_arret_a_chaque_page;
EXTERN char sortie_violente;		/* Quit en cours de connexion */
EXTERN int nb_procedures;
EXTERN struct procedure procedures[MAXPROC];
EXTERN struct chat *chat_courant;
EXTERN char *serveur_xtel;
EXTERN char *zone_enregistrement;
EXTERN unsigned int taille_zone_enregistrement;
EXTERN char version_xtel;
EXTERN char revision_xtel;
EXTERN char prototype_xtel;
EXTERN char *toolkit_utilise;
EXTERN struct definition_service definition_services[MAX_SERVICES];
EXTERN int socket_xteld;
EXTERN String entree_compose[MAX_SERVICES];
EXTERN int nb_services;
EXTERN char mode_emulation;
EXTERN struct definition_touche touches[];
EXTERN XtAppContext app_context;
EXTERN char nom_fichier_sauve[256];
EXTERN char nom_fichier_charge[256];
EXTERN char numero_courant[256];
EXTERN ressources_xtel rsc_xtel;

/* bouton.c */
EXTERN long position_courante_fichier;
EXTERN unsigned int numero_page_courante;
EXTERN unsigned int numero_caractere_courant;

/* lecteur.c */
EXTERN char lecteur_play;

/* teleinfo.c */
EXTERN XtInputId input_id_teleinfo;
EXTERN int fd_teleinfo;
EXTERN int pid_teleinfo;

/* xaw.c */
EXTERN char *toolkit_utilise;
EXTERN Widget bouton_compose;
EXTERN Widget bouton_procedure;
EXTERN Widget menu_clavier;
EXTERN WidgetClass classe_forme_copyright;

/* copyright.c */
EXTERN  Boolean flag_copyright_affiche;

#endif
