/*
 * lsof_field.h - field ID characters for lsof output that can be parsed
 *		  (selected with -f or -F)
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: lsof_fields.h,v 1.7 96/01/09 08:09:12 abe Exp $
 */


#if	!defined(LSOF_FORMAT_H)
#define	LSOF_FORMAT_H	1

/*
 * Codes for output fields:
 *
 *	LSOF_FID_*	ID character
 *	LSOF_FIX_*	ID index
 *	LSOF_FNM_*	name
 *
 * A field is displayed in the form:
 *		<ID_character><data><field_terminator>
 *	
 * Output fields are normally terminated with a NL ('\n'), but the field
 * terminator can be set to NUL with the -0 (zero) option to lsof.
 *
 * Field sets -- process-specific information or information specific
 * to a single file descriptor -- are terminated with NL when the field
 * terminator is NUL.
 */

#define	LSOF_FID_ACCESS		'a'
#define	LSOF_FIX_ACCESS		0
#define	LSOF_FNM_ACCESS		"access: r = read; w = write; u = read/write"

#define	LSOF_FID_CMD		'c'
#define	LSOF_FIX_CMD		1
#define	LSOF_FNM_CMD		"command name"

#define	LSOF_FID_DEVCH		'd'
#define	LSOF_FIX_DEVCH		2
#define	LSOF_FNM_DEVCH		"device character code"

#define	LSOF_FID_DEVN		'D'
#define	LSOF_FIX_DEVN		3
#define	LSOF_FNM_DEVN		"major/minor device number as 0x<hex>"

#define	LSOF_FID_FD		'f'
#define	LSOF_FIX_FD		4
#define	LSOF_FNM_FD		"file descriptor"

#define	LSOF_FID_INODE		'i'
#define	LSOF_FIX_INODE		5
#define	LSOF_FNM_INODE		"inode number"

#define	LSOF_FID_LOCK		'l'
#define	LSOF_FIX_LOCK		6
#define	LSOF_FNM_LOCK		"lock: r/R = read; w/W = write; u = read/write"

#define	LSOF_FID_LOGIN		'L'
#define	LSOF_FIX_LOGIN		7
#define	LSOF_FNM_LOGIN		"login name"

#define	LSOF_FID_MARK		'm'
#define	LSOF_FIX_MARK		8
#define	LSOF_FNM_MARK		"marker between repeated output"

#define	LSOF_FID_NAME		'n'
#define	LSOF_FIX_NAME		9
#define	LSOF_FNM_NAME		"comment, name, Internet addresses"

#define	LSOF_FID_OFFSET		'o'
#define	LSOF_FIX_OFFSET		10
#define	LSOF_FNM_OFFSET		"file offset as 0t<dec> or 0x<hex>"

#define	LSOF_FID_PID		'p'
#define	LSOF_FIX_PID		11
#define	LSOF_FNM_PID		"process ID (PID)"

#define	LSOF_FID_PGRP		'g'
#define	LSOF_FIX_PGRP		12
#define	LSOF_FNM_PGRP		"process group ID (PGRP)"

#define	LSOF_FID_PROTO		'P'
#define	LSOF_FIX_PROTO		13
#define	LSOF_FNM_PROTO		"protocol name"

#define	LSOF_FID_SIZE		's'
#define	LSOF_FIX_SIZE		14
#define	LSOF_FNM_SIZE		"file size"

#define	LSOF_FID_STREAM		'S'
#define	LSOF_FIX_STREAM		15
#define	LSOF_FNM_STREAM		"stream module and device names"

#define	LSOF_FID_TYPE		't'
#define	LSOF_FIX_TYPE		16
#define	LSOF_FNM_TYPE		"file type"

#define	LSOF_FID_UID		'u'
#define	LSOF_FIX_UID		17
#define	LSOF_FNM_UID		"user ID (UID)"

#define	LSOF_FID_TERM		'0'
#define	LSOF_FIX_TERM		18
#define	LSOF_FNM_TERM		"use NUL field terminator instead of NL"

/*
 * Field identifiers '1' through '9' are reserved for dialect-specified
 * fields.
 *
 * These field identifiers have no LSOF_FID_TERM, LSOF_FIX_TERM, or
 * LSOF_FNM_TERM definitions.  LSOF_FID_* is always '1' through '9'.
 * LSOF_FIX_* is always LSOF_FIX_TERM plus the value of the field
 * identifier.  LSOF_FNM_* is the string value of:
 *
 *	HASFIELDAP<field_identifier_digit>
 *
 * Dialects that use these private fields must provide macros for
 * listing them, defined by:
 *
 *	LISTLFILEAP<field_identifier_digit>
 *
 * These definitions are made in the dialect's machine.h header file.
 * See ./dialects/ptx/machine.h for an example.
 */

#endif	/* !defined(LSOF_FORMAT_H) */
