/*
 * dstore.c - AIX global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.4 96/03/08 14:02:30 abe Exp $";
#endif


#include "lsof.h"


/*
 * Global storage definitions
 */

#if	defined(HAS_AFS)
struct nlist AFSnl[] = {
	{ "afs_rootFid",	0, 0, 0, NULL, NULL },
	{ "afs_volumes",	0, 0, 0, NULL, NULL },
};

# if    defined(HASAOPT)
char *AFSApath = (char *)NULL;		/* alternate AFS name list path
					 * (from -a) */
# endif /* defined(HASAOPT) */

struct vfs *AFSVfsp = (struct vfs *)NULL;
				/* AFS vfs struct kernel address */
#endif	/* defined(HAS_AFS) */

int Kmem = -1;				/* /dev/kmem file descriptor */
struct l_vfs *Lvfs = NULL;		/* local vfs structure table */
int Mem = -1;				/* /dev/mem file descriptor */

struct nlist Nl[] = {

#if	_AIXV<4100
	{ "u",			 0, 0, 0, NULL, NULL },
#else	/* _AIXV>=4100 */
	{ "__ublock",		 0, 0, 0, NULL, NULL },
#endif	/* _AIXV<4100 */

};

#if	_AIXV>=4110
struct ublock __ublock;			/* dummy so we can define _KERNEL
					 * for <sys/user.h> */
#endif	/* _AIXV>=4110 */
