From owner-gimp-list@scam.XCF.Berkeley.EDU Wed Jun  5 20:03:47 1996
Status: RO
X-VM-v5-Data: ([nil nil nil t nil nil nil nil nil]
	["8864" "Wed" "5" "June" "1996" "12:28:32" "-0500" "Eric L. Hernes" "erich@lodgenet.com" nil "404" "even cheesier web buttons..." "^From:" nil nil "6" nil nil nil nil]
	nil)
Return-Path: owner-gimp-list@scam.XCF.Berkeley.EDU
Received: from brimstone.unipalm.pipex.com (brimstone.unipalm.pipex.com [146.188.3.250]) by sierra.unipalm.co.uk (8.6.11/8.6.9) with ESMTP id UAA08803 for <adam@sierra.unipalm.co.uk>; Wed, 5 Jun 1996 20:03:42 GMT
Received:  from duct.mail.pipex.net by brimstone.unipalm.pipex.com (8.6.12/PIPEX simple 1.22)
	id UAA02185; Wed, 5 Jun 1996 20:04:20 +0100
Received: from tigerden.com (actually yiffy.tigerden.com) by duct.mail.pipex.net with SMTP (PP);
          Wed, 5 Jun 1996 20:04:11 +0100
Received: from scam.XCF.Berkeley.EDU by tigerden.com with SMTP id AA24942
  (5.67b/IDA-1.5 for <aspirin@tigerden.com>); Wed, 5 Jun 1996 15:04:32 -0400
Received: (from domo@localhost) by scam.XCF.Berkeley.EDU (8.7.5/8.7.3) id KAA08088 for gimp-list-outgoing; Wed, 5 Jun 1996 10:26:40 -0700
Received: from bacall.lodgenet.com (bacall.lodgenet.com [205.138.147.242]) by scam.XCF.Berkeley.EDU (8.7.5/8.7.3) with SMTP id KAA08077 for <gimp-list@scam.XCF.Berkeley.EDU>; Wed, 5 Jun 1996 10:26:32 -0700
Received: (from mail@localhost) by bacall.lodgenet.com (8.6.12/8.6.12) id MAA06126 for <gimp-list@scam.XCF.Berkeley.EDU>; Wed, 5 Jun 1996 12:29:12 -0500
Received: from garbo.lodgenet.com(204.124.123.250) by bacall via smap (V1.3)
	id sma006123; Wed Jun  5 12:28:46 1996
Received: from jake.lodgenet.com (jake.lodgenet.com [204.124.120.30]) by garbo.lodgenet.com (8.6.12/8.6.9) with ESMTP id MAA12596 for <gimp-list@scam.XCF.Berkeley.EDU>; Wed, 5 Jun 1996 12:28:48 -0500
Received: from localhost (localhost [127.0.0.1]) by jake.lodgenet.com (8.7.5/8.6.12) with SMTP id MAA07490 for <gimp-list@scam.XCF.Berkeley.EDU>; Wed, 5 Jun 1996 12:28:32 -0500 (CDT)
Message-Id: <199606051728.MAA07490@jake.lodgenet.com>
X-Authentication-Warning: jake.lodgenet.com: Host localhost [127.0.0.1] didn't use HELO protocol
X-Mailer: exmh version 1.6.2 7/18/95
Mime-Version: 1.0
Precedence: bulk
From: "Eric L. Hernes" <erich@lodgenet.com>
Sender: owner-gimp-list@XCF.Berkeley.EDU
To: gimp-list@scam.XCF.Berkeley.EDU
Subject: even cheesier web buttons...
Date: Wed, 05 Jun 1996 12:28:32 -0500
Content-Type: text/plain; charset=us-ascii



Ok, here's a new chamfer... It's got:

1) a better name button.c (still sucks though, I'm open to suggestion ;-) )
2) operates on only the region, if it's active.
3) round buttons.


The round buttons could really use some anti-aliasing, if
anyone knows how to do this algorithmically, let me know.

have fun.
eric.

/***************************************************
 * file: button.c
 *
 * this program needs a GPL library, so it too
 * is GPL'ed, look for the file called ``COPYING''
 * in any other GPL software.
 *
 * Eric L. Hernes.
 * erich@rrnet.com
 *
 * highly modified chamfer.c, call it version 0.9
 *
 * parts based on ImageMap.java from the Sun JDK demos
 * by Jim Grahm.
 */

#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <math.h>
#include "gimp.h"

static void mystuff(Image, Image);
static int *round_ranges(int, int, int);
static int filter_region(int, int, int, int, int, int, int);

static int *square_ranges(int, int, int);

static int filter_channel(int, int, int, int);
static void scale_cb(int, void *, void *);
static void ok_cb(int, void *, void *);
static void cancel_cb(int, void *, void *);
static void radio_cb(int, void *, void *);

static Image input, output;
static int d_id;

struct param {
  int h;
  int v;
  int pct;
  int round;
  int square;
};

static struct param p1;

#define cy(x0,y0,x1,y1) ((float)(x1-x0)/(float)(y1-y0))
#define dy(x0,y0,x1,y1) (x0-((float)(x1-x0)/(float)(y1-y0))*(float)y0)
#define f_y(x0,y0,x1,y1) ((float)cy(x0,y0,x1,y1) * y + (float)dy(x0,y0,x1,y1))

int
main(int argc, char **argv){
  int t_id, hs_id, hl_id, vs_id, vl_id, t;
  int ps_id, pl_id, rr_id, sr_id;
  int *horiz, *vert, *pct;
  int g0_id, f1_id, f2_id, g1_id, g2_id;
  void *d;

  if (!gimp_init(argc, argv)){
    return(0);
  }
  /* useful stuff */

  input = gimp_get_input_image(0);

  t=gimp_image_type(input);

  if ((t==RGB_IMAGE) || (t==GRAY_IMAGE)){

    d = gimp_get_params();

    if (d){
      bcopy(d, &p1, sizeof(struct param));
    } else {
      p1.h=10;
      p1.v=10;
      p1.pct=75;
      p1.round=0;
      p1.square=1;
    }

    horiz=&p1.h;
    vert=&p1.v;
    pct= &p1.pct;

    d_id = gimp_new_dialog("Button");

    t_id = gimp_new_label(d_id, DEFAULT, "Button");

    g0_id = gimp_new_column_group(d_id, DEFAULT, NORMAL, "");
    f1_id = gimp_new_frame(d_id, g0_id, "Parameters");
    g1_id = gimp_new_row_group(d_id, f1_id, DEFAULT, "");

    f2_id = gimp_new_frame(d_id, g0_id, "Type");
    g2_id = gimp_new_row_group(d_id, f2_id, RADIO, "");

    hs_id = gimp_new_scale(d_id, g1_id, 1, 50, *horiz, 0);
    hl_id = gimp_new_label(d_id, hs_id, "Horizontal");

    vs_id = gimp_new_scale(d_id, g1_id, 1, 50, *vert, 0);
    vl_id = gimp_new_label(d_id, vs_id, "Vertical");

    ps_id = gimp_new_scale(d_id, g1_id, 1, 100, *pct, 0);
    pl_id = gimp_new_label(d_id, ps_id, "Percent Highlight");

    rr_id = gimp_new_radio_button(d_id, g2_id, "Round");
    gimp_change_item(d_id, rr_id, sizeof(p1.round), &p1.round);
    sr_id = gimp_new_radio_button(d_id, g2_id, "Square");
    gimp_change_item(d_id, sr_id, sizeof(p1.square), &p1.square);


    gimp_add_callback(d_id, hs_id, scale_cb, horiz);
    gimp_add_callback(d_id, vs_id, scale_cb, vert);
    gimp_add_callback(d_id, ps_id, scale_cb, pct);

    gimp_add_callback(d_id, rr_id, radio_cb, &p1.round);
    gimp_add_callback(d_id, sr_id, radio_cb, &p1.square);

    gimp_add_callback(d_id, gimp_ok_item_id(d_id), ok_cb, 0);
    gimp_add_callback(d_id, gimp_cancel_item_id(d_id), cancel_cb, 0);

    if(gimp_show_dialog(d_id)){
      gimp_set_params(sizeof(struct param), &p1);

      output = gimp_get_output_image(0);

      mystuff(input, output);

      if(output) {
	gimp_update_image(output);
      }
    }

  } else {
    gimp_message("button: image not my type");
  }

  if(input) {
    gimp_free_image(input);
  }
  if (output) {
    gimp_free_image(output);
  }

  gimp_quit();
  return(0);
}

static void
mystuff(Image I1, Image I2){
  long X, Y;
  long channels, rowstride;
  u_char *src_row, *dst_row;
  u_char *src, *dst;
  short x, y, xx, yy;
  int x1, x2, y1, y2, c;
  int w, h, i, *ranges;
  int rgb;

  gimp_image_area(I1, &x1, &y1, &x2, &y2);

  w = gimp_image_width(I1);
  h = gimp_image_height(I1);

  X = x2 - x1;
  Y = y2 - y1;

  channels = gimp_image_channels(I1);

  rowstride = w * channels;

  src_row=gimp_image_data(I1);
  dst_row=gimp_image_data(I2);

  src_row += rowstride * y1 + x1*channels;
  dst_row += rowstride * y1 + x1*channels;

  for(yy=y1; yy<y2; yy++) {
    y=yy-y1;
    if (p1.round) {
      ranges = round_ranges(y, X, Y);
    } else {
      ranges = square_ranges(y, X, Y);
    }
    src = src_row;
    dst = dst_row;
    for(xx=x1; xx<x2; xx++){
      x=xx-x1;

      rgb=0;

      for(c=0; c<channels; c++){
	rgb |= src[c]<<(c*8);
      }

      /* now rgb = 00:b:g:r for the rgb case 
       * and rgb = 00:00:00:g for the greyscale case
       */
      
      for (i=0; i<7; i++){
	if (x >=ranges[i] && x<ranges[i+1]) {
	  break; /* our region, bail */
	}
      }

	rgb = filter_region(i, x, y, X, Y, rgb, channels);

      for(c=0; c<channels; c++){
	dst[c] = (rgb>>(c*8)) & 0xff;
      }
      src+=channels;
      dst+=channels;
    }
    src_row += rowstride;
    dst_row += rowstride;
  }
}


int *
round_ranges(int y, int X, int Y){
  static int ranges[8];
  int Xcenter, Ycenter, Yradsq, innerW, innerH, Yrad2sq;
  int xrel, yrel, xslash, xrel2;

  Xcenter = X / 2;
  Ycenter = Y / 2;
  Yradsq = Y * Y / 4;
  innerW = X - p1.h * 2;
  innerH = Y - p1.v * 2;
  Yrad2sq = innerH * innerH / 4;

  yrel = abs(Ycenter - y);
  xrel = sqrt((double)(Yradsq - yrel * yrel)) * (double)X / (double)Y;
  xslash = X - (y * (double)X / (double) Y);
  ranges[0] = 0;
  ranges[1] = Xcenter - xrel;
  ranges[6] = Xcenter + xrel;
  ranges[7] = X;
  if (y<p1.v){
    ranges[2] = ranges[3] = ranges[4] = Xcenter;
    ranges[5] = ranges[6];
  } else if (y + p1.v >= Y) {
    ranges[2] = ranges[1];
    ranges[3] = ranges[4] = ranges[5] = Xcenter;
  } else {
    xrel2 = (int)sqrt(Yrad2sq - yrel * yrel) * ((double)innerW / 
(double)innerH);
    ranges[3] = Xcenter - xrel2;
    ranges[4] = Xcenter + xrel2;
    if (y<Ycenter){
      ranges[2] = ranges[3];
      ranges[5] = ranges[6];
    } else {
      ranges[2] = ranges[1];
      ranges[5] = ranges[4];
    }
  }
  return(ranges);
}

static int
filter_region(int region, int x, int y, int X, int Y, int rgb, int nchan) {
  int brighter=1, percent;
  double angle;
  int Xcenter, Ycenter;

  percent = p1.pct;

  Xcenter = X/2;
  Ycenter = Y/2;

  switch (region) {
  default:
  case 0:
  case 6:
    return(rgb);
  case 1:
    brighter=1;
    percent= p1.pct;
    break;
  case 5:
    brighter=0;
    percent = p1.pct;
    break;
  case 2:
    angle = atan2((double)(y-Ycenter), (double)(Xcenter-x));
    percent = -(p1.pct - (cos(angle)*2*p1.pct));
    if (percent == 0) {
      return (rgb);
    } else if (percent < 0){
      percent = -percent;
      brighter = 0;
    } else {
      brighter = 1;
    }
    break;
  case 4:
    angle = atan2(Ycenter -y, x - Xcenter);
    percent = p1.pct - (int)(cos(angle)*2*p1.pct);
    if (percent == 0) {
      return (rgb);
    } else if (percent < 0){
      percent = -percent;
      brighter = 0;
    } else {
      brighter = 1;
    }
    break;
  case 3:
#ifdef HIGHLIGHT_FACE
    brighter=1;
    percent=p1.pct/6;
#else 
    percent=0;
#endif
    break;
  }
  return(filter_channel(rgb, brighter, percent, nchan));
}

int *
square_ranges(int y, int X, int Y){
  static int ranges[8];

  ranges[0] = ranges[1] = 0;
  if (y<p1.v) {
        ranges[2] = ranges[3] = ranges[4] = ranges[5] =X-f_y(0,0,p1.h,p1.v);
  } else if (y > Y - p1.v) {
    ranges[2] = ranges[3] = ranges[4] = ranges[5] = f_y(0,Y,p1.h,Y-p1.v);
  } else {
    ranges[2] = ranges[3] = p1.h;
    ranges[4] = ranges[5] = X - p1.h;
  }
  ranges[6] = ranges[7] = X;
  return(ranges);
}

static int
filter_channel(int rgb, int brighter, int percent, int nchan){
  int i;
  short chan;
  int r=0;
  
  for(i=0; i<nchan; i++){
    chan = (rgb>>(i*8))& 0xff;

    chan = (brighter) ?
      (255 - ((255 - chan) * (double)(100 - percent) / (double)100)) :
      (chan * (double)(100-percent) / (double)100);
    chan = (chan <0) ? 0 : chan;
    chan = (chan >255) ? 255 : chan;

    r |= (chan<<(i*8));
  }
  return(r);
}

static void
scale_cb(int id, void *c_data, void *ca_data){
  int n;
  n= *((long *)ca_data);
  *((int *)c_data) = n;
}

static void
ok_cb(int id, void *c_data, void *ca_data){
  gimp_close_dialog(d_id, 1);
}

static void
cancel_cb(int id, void *c_data, void *ca_data){
  gimp_close_dialog(d_id, 0);
}

static void
radio_cb(int id, void *c_data, void *ca_data) {
    *((long *) c_data) = *((long *) ca_data);
} /* radio_cb */

/* end of button.c */



--
erich@lodgenet.com
http://rrnet.com/~erich erich@rrnet.com


