#define XPCD_VERSION     "xpcd 2.07"

#define max(x,y)         (((x) < (y)) ? (y) : (x))
#define min(x,y)         (((x) > (y)) ? (y) : (x))

#define VIEWER_INTERN    ((XtPointer)-1)
#define VIEWER_GIMP      ((XtPointer)-2)

#define PERROR(str)      fprintf(stderr,"%s:%d: %s: %s\n",__FILE__,__LINE__,str,strerror(errno))

/* --- main.c --- */

extern Widget   app_shell;
extern XtAppContext app_context;
extern Display *dpy;

extern int      use_grays;
extern int      force_grays;
extern int      load_grays;
extern int      tiny_turn;
extern int      jpeg_quality;
extern int      tiff_compress;
extern char     gimp_sock[];

extern int      viewer_current;
extern char    *viewer_cmd[];

/* --- file.c --- */

Boolean         open_file_WP(XtPointer client_data);
void            add_window_to_list(Widget shell, char *filename);
void            close_file_AC(Widget widget, XEvent * event,
			      String * params, Cardinal * num_params);
void            close_all_files(void);

/* --- loadimage.c --- */

void            loadimage(Widget shell, struct PCD_IMAGE *,
			  int, int, int, int, int, char *, char *);

/* --- viewer.c --- */

void            close_viewer_AC(Widget widget, XEvent * event,
				String * params, Cardinal * num_params);
void            new_viewer(int, unsigned char *, int pid, char *, int, int);
